/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.mapmatching;

import com.bmwcarit.barefoot.matcher.Matcher;
import com.bmwcarit.barefoot.matcher.MatcherCandidate;
import com.bmwcarit.barefoot.matcher.MatcherKState;
import com.bmwcarit.barefoot.matcher.MatcherSample;
import com.bmwcarit.barefoot.roadmap.Loader;
import com.bmwcarit.barefoot.roadmap.RoadMap;
import com.bmwcarit.barefoot.roadmap.TimePriority;
import com.bmwcarit.barefoot.spatial.Geography;
import com.bmwcarit.barefoot.spatial.SpatialOperator;
import com.bmwcarit.barefoot.topology.Cost;
import com.bmwcarit.barefoot.topology.Dijkstra;
import com.bmwcarit.barefoot.topology.Router;
import com.esri.core.geometry.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public final class MapMatchingNodeModel
extends NodeModel {
    private final SettingsModelString mapMatchingFrameworkModel;
    private final SettingsModelString serverAddressInputModel;
    private final SettingsModelString serverPortInputModel;
    private final SettingsModelString databaseNameInputModel;
    private final SettingsModelString databaseTableInputModel;
    private final SettingsModelString databaseUserInputModel;
    private final SettingsModelString databasePasswordInputModel;
    private final SettingsModelString databaseRoadTypesInputModel;
    private final SettingsModelString latInputColumnModel;
    private final SettingsModelString lonInputColumnModel;
    private final SettingsModelString headingInputColumnModel;
    private final SettingsModelString idInputColumnModel;
    private final SettingsModelString timestampInputColumnModel;

    public MapMatchingNodeModel(SettingsModelString mapMatchingFrameworkModel, SettingsModelString serverAddressInputModel, SettingsModelString serverPortInputModel, SettingsModelString databaseNameInputModel, SettingsModelString databaseTableInputModel, SettingsModelString databaseUserInputModel, SettingsModelString databasePasswordInputModel, SettingsModelString databaseRoadTypesInputModel, SettingsModelString latInputColumnModel, SettingsModelString lonInputColumnModel, SettingsModelString headingInputColumnModel, SettingsModelString idInputColumnModel, SettingsModelString timestampInputColumnModel) {
        super(1, 1);
        this.mapMatchingFrameworkModel = mapMatchingFrameworkModel;
        this.serverAddressInputModel = serverAddressInputModel;
        this.serverPortInputModel = serverPortInputModel;
        this.databaseNameInputModel = databaseNameInputModel;
        this.databaseTableInputModel = databaseTableInputModel;
        this.databaseUserInputModel = databaseUserInputModel;
        this.databasePasswordInputModel = databasePasswordInputModel;
        this.databaseRoadTypesInputModel = databaseRoadTypesInputModel;
        this.latInputColumnModel = latInputColumnModel;
        this.lonInputColumnModel = lonInputColumnModel;
        this.headingInputColumnModel = headingInputColumnModel;
        this.idInputColumnModel = idInputColumnModel;
        this.timestampInputColumnModel = timestampInputColumnModel;
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.mapMatchingFrameworkModel.saveSettingsTo(settings);
        this.serverAddressInputModel.saveSettingsTo(settings);
        this.serverPortInputModel.saveSettingsTo(settings);
        this.databaseNameInputModel.saveSettingsTo(settings);
        this.databaseTableInputModel.saveSettingsTo(settings);
        this.databaseUserInputModel.saveSettingsTo(settings);
        this.databasePasswordInputModel.saveSettingsTo(settings);
        this.databaseRoadTypesInputModel.saveSettingsTo(settings);
        this.latInputColumnModel.saveSettingsTo(settings);
        this.lonInputColumnModel.saveSettingsTo(settings);
        this.headingInputColumnModel.saveSettingsTo(settings);
        this.idInputColumnModel.saveSettingsTo(settings);
        this.timestampInputColumnModel.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.mapMatchingFrameworkModel.validateSettings(settings);
        this.serverAddressInputModel.validateSettings(settings);
        this.serverPortInputModel.validateSettings(settings);
        this.databaseNameInputModel.validateSettings(settings);
        this.databaseTableInputModel.validateSettings(settings);
        this.databaseUserInputModel.validateSettings(settings);
        this.databasePasswordInputModel.validateSettings(settings);
        this.databaseRoadTypesInputModel.validateSettings(settings);
        this.latInputColumnModel.validateSettings(settings);
        this.lonInputColumnModel.validateSettings(settings);
        this.headingInputColumnModel.validateSettings(settings);
        this.idInputColumnModel.validateSettings(settings);
        this.timestampInputColumnModel.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.mapMatchingFrameworkModel.loadSettingsFrom(settings);
        this.serverAddressInputModel.loadSettingsFrom(settings);
        this.serverPortInputModel.loadSettingsFrom(settings);
        this.databaseNameInputModel.loadSettingsFrom(settings);
        this.databaseTableInputModel.loadSettingsFrom(settings);
        this.databaseUserInputModel.loadSettingsFrom(settings);
        this.databasePasswordInputModel.loadSettingsFrom(settings);
        this.databaseRoadTypesInputModel.loadSettingsFrom(settings);
        this.latInputColumnModel.loadSettingsFrom(settings);
        this.lonInputColumnModel.loadSettingsFrom(settings);
        this.headingInputColumnModel.loadSettingsFrom(settings);
        this.idInputColumnModel.loadSettingsFrom(settings);
        this.timestampInputColumnModel.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        Properties dbProperties = new Properties();
        dbProperties.put("database.host", this.serverAddressInputModel.getStringValue());
        dbProperties.put("database.port", this.serverPortInputModel.getStringValue());
        dbProperties.put("database.name", this.databaseNameInputModel.getStringValue());
        dbProperties.put("database.table", this.databaseTableInputModel.getStringValue());
        dbProperties.put("database.user", this.databaseUserInputModel.getStringValue());
        dbProperties.put("database.password", this.databasePasswordInputModel.getStringValue());
        dbProperties.put("database.road-types", this.databaseRoadTypesInputModel.getStringValue());
        RoadMap map = Loader.roadmap((Properties)dbProperties, (boolean)true);
        Matcher matcher = new Matcher(map, (Router)new Dijkstra(), (Cost)new TimePriority(), (SpatialOperator)new Geography());
        map.construct();
        List<MatcherSample> samples = this.loadInputData(inData);
        MatcherKState state = matcher.mmatch(samples, 1.0, 500);
        DataColumnSpec latColSpec = new DataColumnSpecCreator("Latitude", DoubleCell.TYPE).createSpec();
        DataColumnSpec lonColSpec = new DataColumnSpecCreator("Longitude", DoubleCell.TYPE).createSpec();
        DataTableSpec outSpec = new DataTableSpec(new DataColumnSpec[]{latColSpec, lonColSpec});
        BufferedDataContainer container = exec.createDataContainer(outSpec);
        for (MatcherCandidate cand : state.sequence()) {
            RowKey key = new RowKey(cand.id());
            DoubleCell latCell = new DoubleCell(cand.point().geometry().getX());
            DoubleCell lonCell = new DoubleCell(cand.point().geometry().getY());
            DefaultRow row = new DefaultRow(key, new DataCell[]{latCell, lonCell});
            container.addRowToTable((DataRow)row);
        }
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    private List<MatcherSample> loadInputData(BufferedDataTable[] inData) {
        ArrayList<MatcherSample> samples = new ArrayList<MatcherSample>();
        BufferedDataTable input = inData[0];
        double latitude = 0.0;
        double longitude = 0.0;
        long time = 0L;
        long id = 0L;
        boolean isFirstIteration = true;
        DataTableSpec inputSpec = input.getDataTableSpec();
        int latIndex = inputSpec.findColumnIndex("lat");
        int lonIndex = inputSpec.findColumnIndex("lon");
        int gpsTimeIndex = inputSpec.findColumnIndex("gps_time");
        for (DataRow row : input) {
            double nextLatitude = ((DoubleCell)row.getCell(latIndex)).getDoubleValue();
            double nextLongitude = ((DoubleCell)row.getCell(lonIndex)).getDoubleValue();
            long nextTime = ((LongCell)row.getCell(gpsTimeIndex)).getLongValue();
            long nextId = Long.valueOf(row.getKey().getString());
            if (!isFirstIteration) {
                double opposite = Math.abs(nextLatitude - latitude);
                double adjacent = Math.abs(nextLongitude - longitude);
                double tangens = opposite / adjacent;
                double angleInRadians = Math.atan(tangens);
                double angleInDegrees = angleInRadians * 180.0 / Math.PI;
                double azimuth = 360.0 - angleInDegrees;
                Point point = new Point(longitude, latitude);
                samples.add(new MatcherSample(String.valueOf(id), time, point, azimuth));
            } else {
                isFirstIteration = false;
            }
            latitude = nextLatitude;
            longitude = nextLongitude;
            time = nextTime;
            id = nextId;
        }
        Point point = new Point(longitude, latitude);
        samples.add(new MatcherSample(String.valueOf(id), time, point, 360.0));
        return samples;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[0];
    }
}

