/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.reader;

import de.cyface.knime.dialog.FileSelectionNodeOption;
import de.cyface.knime.dialog.StringSelectionNodeOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public final class BinaryFormatReaderNodeModel
extends NodeModel {
    private final SettingsModelString inputFileSettings;
    private final SettingsModelString inputTypeSettings;

    protected BinaryFormatReaderNodeModel(FileSelectionNodeOption inputFileSelectionOption, StringSelectionNodeOption stringSelectionOption) {
        super(0, 5);
        this.inputFileSettings = inputFileSelectionOption.getSettingsModel();
        this.inputTypeSettings = stringSelectionOption.getSettingsModel();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        block28: {
            String inputFilePath = this.inputFileSettings.getStringValue();
            File inputFile = new File(inputFilePath);
            if (!inputFile.exists()) {
                throw new InvalidSettingsException("Input file to read Cyface binary data from, does not exist!");
            }
            String inputType = this.inputTypeSettings.getStringValue();
            if (inputType.equals("Measurement")) {
                try {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (FileInputStream inputFileStream = new FileInputStream(inputFilePath);){
                        if (this.readShort(inputFileStream) != 1) {
                            throw new InvalidSettingsException("Either the input file was no uncompressed file in Cyface binary format or it has the wrong version. Only version 1 is supported at the moment.");
                        }
                        break block28;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new InvalidSettingsException((Throwable)e);
                }
            }
            if (inputType.equals("Events")) {
                try {
                    Throwable e = null;
                    Object var6_13 = null;
                    try (FileInputStream inputFileStream = new FileInputStream(inputFilePath);){
                        if (this.readShort(inputFileStream) != 1) {
                            throw new InvalidSettingsException("Either the input file was no uncompressed file in Cyface Events binary format or it has the wrong version. Only version 1 is supported at the moment.");
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new InvalidSettingsException((Throwable)e);
                }
            }
            if (inputFile.length() % 32L != 0L) {
                throw new InvalidSettingsException("The input file seems to be no valid uncompressed 3D point data file (i.e. accelerations, rotations or directions). If you selected a measurement file please select Measurement as file type. Otherwise check that your file is actually valid.");
            }
        }
        return new DataTableSpec[]{this.getGeoLocationsTableSpec(), this.getPoint3DTableSpec(), this.getPoint3DTableSpec(), this.getPoint3DTableSpec(), this.getEventsTableSpec()};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        String inputFilePath = this.inputFileSettings.getStringValue();
        File inputFile = new File(inputFilePath);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream inputFileStream = new FileInputStream(inputFile);){
            int rotationsCount;
            int accelerationsCount;
            int geoLocationsCount;
            String inputType = this.inputTypeSettings.getStringValue();
            if (inputType.equals("Measurement") || inputType.equals("Events")) {
                ((InputStream)inputFileStream).skip(2L);
            }
            int n = geoLocationsCount = inputType.equals("Measurement") ? this.readInt(inputFileStream) : 0;
            int n2 = inputType.equals("Measurement") ? this.readInt(inputFileStream) : (accelerationsCount = inputType.equals("Accelerations") ? (int)inputFile.length() / 32 : 0);
            int n3 = inputType.equals("Measurement") ? this.readInt(inputFileStream) : (rotationsCount = inputType.equals("Rotations") ? (int)inputFile.length() / 32 : 0);
            int directionsCount = inputType.equals("Measurement") ? this.readInt(inputFileStream) : (inputType.equals("Directions") ? (int)inputFile.length() / 32 : 0);
            int eventsCount = inputType.equals("Events") ? this.readInt(inputFileStream) : 0;
            exec.checkCanceled();
            int processingSteps = geoLocationsCount + accelerationsCount + rotationsCount + directionsCount + eventsCount;
            ExecutionMonitor geoLocationsProgressMonitor = exec.createSubProgress((double)geoLocationsCount / (double)processingSteps);
            BufferedDataTable geoLocationsTable = inputType.equals("Measurement") ? this.readGeoLocationsTable(inputFileStream, geoLocationsCount, exec, geoLocationsProgressMonitor, processingSteps) : this.createEmptyTable(this.getGeoLocationsTableSpec(), exec);
            exec.checkCanceled();
            ExecutionMonitor accelerationsProgressMonitor = exec.createSubProgress((double)accelerationsCount / (double)processingSteps);
            BufferedDataTable accelerationsTable = inputType.equals("Measurement") || inputType.equals("Accelerations") ? this.readPoint3DTable(inputFileStream, accelerationsCount, exec, accelerationsProgressMonitor, processingSteps) : this.createEmptyTable(this.getPoint3DTableSpec(), exec);
            exec.checkCanceled();
            ExecutionMonitor rotationsProgressMonitor = exec.createSubProgress((double)rotationsCount / (double)processingSteps);
            BufferedDataTable rotationsTable = inputType.equals("Measurement") || inputType.equals("Rotations") ? this.readPoint3DTable(inputFileStream, rotationsCount, exec, rotationsProgressMonitor, processingSteps) : this.createEmptyTable(this.getPoint3DTableSpec(), exec);
            exec.checkCanceled();
            ExecutionMonitor directionsProgressMonitor = exec.createSubProgress((double)directionsCount / (double)processingSteps);
            BufferedDataTable directionsTable = inputType.equals("Measurement") || inputType.equals("Directions") ? this.readPoint3DTable(inputFileStream, directionsCount, exec, directionsProgressMonitor, processingSteps) : this.createEmptyTable(this.getPoint3DTableSpec(), exec);
            ExecutionMonitor eventsProgressMonitor = exec.createSubProgress((double)eventsCount / (double)processingSteps);
            BufferedDataTable eventsTable = inputType.equals("Events") ? this.readEventsTable(inputFileStream, eventsCount, exec, eventsProgressMonitor, processingSteps) : this.createEmptyTable(this.getEventsTableSpec(), exec);
            return new BufferedDataTable[]{geoLocationsTable, accelerationsTable, rotationsTable, directionsTable, eventsTable};
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private BufferedDataTable createEmptyTable(DataTableSpec spec, ExecutionContext context) {
        BufferedDataContainer container = context.createDataContainer(spec);
        container.close();
        return container.getTable();
    }

    private short readShort(InputStream input) throws IOException {
        return this.read(input, 2).getShort();
    }

    private int readInt(InputStream input) throws IOException {
        return this.read(input, 4).getInt();
    }

    private long readLong(InputStream input) throws IOException {
        return this.read(input, 8).getLong();
    }

    private double readDouble(InputStream input) throws IOException {
        return this.read(input, 8).getDouble();
    }

    private String readString(InputStream input, int bytes) throws IOException {
        ByteBuffer byteBuffer = this.read(input, bytes);
        return StandardCharsets.UTF_8.decode(byteBuffer).toString();
    }

    private ByteBuffer read(InputStream input, int bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        int i = 0;
        while (i < bytes) {
            int readByteAsInt = input.read();
            if (readByteAsInt == -1) {
                throw new StreamCorruptedException("Unexpected end of stream reached!");
            }
            byte readByte = (byte)readByteAsInt;
            buffer.put(readByte);
            ++i;
        }
        buffer.position(0);
        return buffer;
    }

    private BufferedDataTable readGeoLocationsTable(InputStream input, int count, ExecutionContext context, ExecutionMonitor monitor, int processingSteps) throws IOException, CanceledExecutionException {
        BufferedDataContainer geoLocationsContainer = context.createDataContainer(this.getGeoLocationsTableSpec());
        int i = 0;
        while (i < count) {
            long timestamp = this.readLong(input);
            double latitude = this.readDouble(input);
            double longitude = this.readDouble(input);
            double speed = this.readDouble(input);
            int accuracy = this.readInt(input);
            LongCell timestampCell = new LongCell(timestamp);
            DoubleCell latitudeCell = new DoubleCell(latitude);
            DoubleCell longitudeCell = new DoubleCell(longitude);
            DoubleCell speedCell = new DoubleCell(speed);
            IntCell accuracyCell = new IntCell(accuracy);
            DefaultRow row = new DefaultRow(new RowKey(String.valueOf(i)), new DataCell[]{timestampCell, latitudeCell, longitudeCell, speedCell, accuracyCell});
            geoLocationsContainer.addRowToTable((DataRow)row);
            context.checkCanceled();
            monitor.setProgress((double)i / (double)processingSteps);
            ++i;
        }
        geoLocationsContainer.close();
        return geoLocationsContainer.getTable();
    }

    private BufferedDataTable readPoint3DTable(InputStream input, int count, ExecutionContext context, ExecutionMonitor monitor, int processingSteps) throws IOException, CanceledExecutionException {
        BufferedDataContainer point3DContainer = context.createDataContainer(this.getPoint3DTableSpec());
        int i = 0;
        while (i < count) {
            long timestamp = this.readLong(input);
            double xValue = this.readDouble(input);
            double yValue = this.readDouble(input);
            double zValue = this.readDouble(input);
            LongCell timestampCell = new LongCell(timestamp);
            DoubleCell xCell = new DoubleCell(xValue);
            DoubleCell yCell = new DoubleCell(yValue);
            DoubleCell zCell = new DoubleCell(zValue);
            DefaultRow row = new DefaultRow(new RowKey(String.valueOf(i)), new DataCell[]{timestampCell, xCell, yCell, zCell});
            point3DContainer.addRowToTable((DataRow)row);
            context.checkCanceled();
            monitor.setProgress((double)i / (double)processingSteps);
            ++i;
        }
        point3DContainer.close();
        return point3DContainer.getTable();
    }

    private BufferedDataTable readEventsTable(InputStream input, int count, ExecutionContext context, ExecutionMonitor monitor, int processingSteps) throws IOException, CanceledExecutionException {
        BufferedDataContainer eventsContainer = context.createDataContainer(this.getEventsTableSpec());
        int i = 0;
        while (i < count) {
            long timestamp = this.readLong(input);
            short eventType = this.readShort(input);
            short valueByteLength = this.readShort(input);
            String value = this.readString(input, valueByteLength);
            LongCell timestampCell = new LongCell(timestamp);
            IntCell eventTypeCell = new IntCell((int)eventType);
            StringCell valueCell = new StringCell(value);
            DefaultRow row = new DefaultRow(new RowKey(String.valueOf(i)), new DataCell[]{timestampCell, eventTypeCell, valueCell});
            eventsContainer.addRowToTable((DataRow)row);
            context.checkCanceled();
            monitor.setProgress((double)i / (double)processingSteps);
            ++i;
        }
        eventsContainer.close();
        return eventsContainer.getTable();
    }

    private DataTableSpec getGeoLocationsTableSpec() {
        DataColumnSpec timestampColumnSpec = new DataColumnSpecCreator("Timestamp", LongCell.TYPE).createSpec();
        DataColumnSpec latitudeColumnSpec = new DataColumnSpecCreator("Latitude", DoubleCell.TYPE).createSpec();
        DataColumnSpec longitudeColumnSpec = new DataColumnSpecCreator("Longitude", DoubleCell.TYPE).createSpec();
        DataColumnSpec speedColumnSpec = new DataColumnSpecCreator("Speed", DoubleCell.TYPE).createSpec();
        DataColumnSpec accuracyColumnSpec = new DataColumnSpecCreator("Accuracy", IntCell.TYPE).createSpec();
        DataTableSpec spec = new DataTableSpec(new DataColumnSpec[]{timestampColumnSpec, latitudeColumnSpec, longitudeColumnSpec, speedColumnSpec, accuracyColumnSpec});
        return spec;
    }

    private DataTableSpec getPoint3DTableSpec() {
        DataColumnSpec timestampColumnSpec = new DataColumnSpecCreator("Timestamp", LongCell.TYPE).createSpec();
        DataColumnSpec xColumnSpec = new DataColumnSpecCreator("x", DoubleCell.TYPE).createSpec();
        DataColumnSpec yColumnSpec = new DataColumnSpecCreator("y", DoubleCell.TYPE).createSpec();
        DataColumnSpec zColumnSpec = new DataColumnSpecCreator("z", DoubleCell.TYPE).createSpec();
        DataTableSpec spec = new DataTableSpec(new DataColumnSpec[]{timestampColumnSpec, xColumnSpec, yColumnSpec, zColumnSpec});
        return spec;
    }

    private DataTableSpec getEventsTableSpec() {
        DataColumnSpec timestampColumnSpec = new DataColumnSpecCreator("Timestamp", LongCell.TYPE).createSpec();
        DataColumnSpec eventTypeColumnSpec = new DataColumnSpecCreator("EventType", IntCell.TYPE).createSpec();
        DataColumnSpec valueColumnSpec = new DataColumnSpecCreator("Value", StringCell.TYPE).createSpec();
        DataTableSpec spec = new DataTableSpec(new DataColumnSpec[]{timestampColumnSpec, eventTypeColumnSpec, valueColumnSpec});
        return spec;
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.inputFileSettings.saveSettingsTo(settings);
        this.inputTypeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputFileSettings.validateSettings(settings);
        this.inputTypeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputFileSettings.loadSettingsFrom(settings);
        this.inputTypeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

