/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.smoothing;

import de.cyface.knime.nodes.smoothing.AppendColumnExecutor;
import de.cyface.knime.nodes.smoothing.Execution;
import de.cyface.knime.nodes.smoothing.Filter;
import de.cyface.knime.nodes.smoothing.ReplaceColumnExecutor;
import de.cyface.knime.nodes.smoothing.algorithm.Algorithm;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class SmoothingNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(SmoothingNodeModel.class);
    private Execution executor;
    private final SettingsModelString filterTypeSelectionSettingsModel;
    private final SettingsModelString inputColSelectionSettingsModel;
    private final SettingsModelString appendReplaceChooserSettingsModel;
    private final SettingsModelString appendColumnNameInputSettingsModel;
    private final SettingsModelInteger windowSizeSelectorSettingsModel;
    private Algorithm algorithm;

    protected SmoothingNodeModel(Execution executor, SettingsModelString filterTypeSelectionSettingsModel, SettingsModelString inputColSelectionSettingsModel, SettingsModelString appendReplaceChooserSettingsModel, SettingsModelString appendColumnNameInputSettingsModel, SettingsModelInteger windowSizeSelectorSettingsModel) {
        super(1, 1);
        this.filterTypeSelectionSettingsModel = filterTypeSelectionSettingsModel;
        this.algorithm = this.selectAlgorithm();
        filterTypeSelectionSettingsModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SmoothingNodeModel.this.algorithm = SmoothingNodeModel.this.selectAlgorithm();
            }
        });
        this.inputColSelectionSettingsModel = inputColSelectionSettingsModel;
        this.appendReplaceChooserSettingsModel = appendReplaceChooserSettingsModel;
        this.appendReplaceChooserSettingsModel.addChangeListener(event -> {
            if (appendReplaceChooserSettingsModel.getStringValue().equals("Replace")) {
                appendColumnNameInputSettingsModel.setEnabled(false);
                this.setExecutor(new ReplaceColumnExecutor());
            } else {
                appendColumnNameInputSettingsModel.setEnabled(true);
                this.setExecutor(new AppendColumnExecutor(appendColumnNameInputSettingsModel));
            }
        });
        this.appendColumnNameInputSettingsModel = appendColumnNameInputSettingsModel;
        this.windowSizeSelectorSettingsModel = windowSizeSelectorSettingsModel;
        this.executor = executor;
    }

    private Algorithm selectAlgorithm() {
        String value = this.filterTypeSelectionSettingsModel.getStringValue();
        if (Filter.RECTANGULAR.getName().equals(value)) {
            return Filter.RECTANGULAR.getAlgorithm();
        }
        if (Filter.TRIANGULAR.getName().equals(value)) {
            return Filter.TRIANGULAR.getAlgorithm();
        }
        throw new IllegalStateException("Unsupported algorithm " + value + " selected!");
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.filterTypeSelectionSettingsModel.saveSettingsTo(settings);
        this.inputColSelectionSettingsModel.saveSettingsTo(settings);
        this.appendReplaceChooserSettingsModel.saveSettingsTo(settings);
        this.appendColumnNameInputSettingsModel.saveSettingsTo(settings);
        this.windowSizeSelectorSettingsModel.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.filterTypeSelectionSettingsModel.validateSettings(settings);
        this.inputColSelectionSettingsModel.validateSettings(settings);
        this.appendReplaceChooserSettingsModel.validateSettings(settings);
        this.appendColumnNameInputSettingsModel.validateSettings(settings);
        SettingsModelString appendColumnNameInputSettingsModelClone = (SettingsModelString)this.appendColumnNameInputSettingsModel.createCloneWithValidatedValue(settings);
        SettingsModelString appendReplaceChooserSettingsModelClone = (SettingsModelString)this.appendReplaceChooserSettingsModel.createCloneWithValidatedValue(settings);
        if (appendReplaceChooserSettingsModelClone.getStringValue().equals("Append") && (appendColumnNameInputSettingsModelClone.getStringValue() == null || appendColumnNameInputSettingsModelClone.getStringValue().isEmpty())) {
            throw new InvalidSettingsException("Please provide a name for the appended output column.");
        }
        this.windowSizeSelectorSettingsModel.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.filterTypeSelectionSettingsModel.loadSettingsFrom(settings);
        this.inputColSelectionSettingsModel.loadSettingsFrom(settings);
        this.appendReplaceChooserSettingsModel.loadSettingsFrom(settings);
        this.appendColumnNameInputSettingsModel.loadSettingsFrom(settings);
        this.windowSizeSelectorSettingsModel.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataContainer outputContainer;
        block9: {
            BufferedDataTable inputTable = inData[0];
            String inputColumnName = this.inputColSelectionSettingsModel.getStringValue();
            LOGGER.debug((Object)String.format("Reading input from column %s.", inputColumnName));
            DataTableSpec inputSpec = inputTable.getSpec();
            DataTableSpec outputSpec = this.executor.getOutputSpec(inputSpec);
            outputContainer = exec.createDataContainer(outputSpec);
            int inputColumnIndex = inputSpec.findColumnIndex(inputColumnName);
            if (!inputSpec.getColumnSpec(inputColumnIndex).getType().isCompatible(DoubleValue.class)) {
                LOGGER.warn((Object)("Invalid data type in input column. " + inputColumnName));
                return new BufferedDataTable[]{outputContainer.getTable()};
            }
            int windowSize = this.windowSizeSelectorSettingsModel.getIntValue();
            LinkedList<DataRow> window = new LinkedList<DataRow>();
            CloseableRowIterator iter = inputTable.iterator();
            try {
                try {
                    int i = 0;
                    while (i < windowSize - 1) {
                        exec.checkCanceled();
                        window.offer(iter.next());
                        ++i;
                    }
                    double itemsProcessed = 0.0;
                    double[] windowValues = new double[windowSize];
                    while (iter.hasNext()) {
                        exec.checkCanceled();
                        exec.setProgress(itemsProcessed / (double)inputTable.size());
                        itemsProcessed += 1.0;
                        window.offer(iter.next());
                        DataRow currentRow = (DataRow)window.get(windowSize > 1 ? windowSize / 2 + 1 : 0);
                        int i2 = 0;
                        while (i2 < windowSize) {
                            windowValues[i2] = ((DoubleCell)((DataRow)window.get(i2)).getCell(inputColumnIndex)).getDoubleValue();
                            ++i2;
                        }
                        LOGGER.info((Object)("Calculating smoothing with window " + windowValues));
                        double smoothedValue = this.algorithm.smooth(windowValues);
                        LOGGER.info((Object)("Result: " + smoothedValue));
                        DoubleCell resultCell = new DoubleCell(smoothedValue);
                        DataRow extendedRow = this.executor.createResultRow(currentRow, (DataCell)resultCell, inputColumnIndex);
                        outputContainer.addRowToTable(extendedRow);
                        window.poll();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    LOGGER.warn((Object)"Window Size was larger than table. No smoothing possible!");
                    outputContainer.close();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                outputContainer.close();
                throw throwable;
            }
            outputContainer.close();
        }
        return new BufferedDataTable[]{outputContainer.getTable()};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (!inSpecs[0].containsCompatibleType(DoubleValue.class)) {
            throw new InvalidSettingsException("Smoothing node input contains no valid column, compatible to double values. Add a column with double values to the input, to use this node.");
        }
        if (!inSpecs[0].containsName(this.inputColSelectionSettingsModel.getStringValue())) {
            for (DataColumnSpec columnSpec : inSpecs[0]) {
                if (!columnSpec.getType().isCompatible(DoubleValue.class)) continue;
                this.inputColSelectionSettingsModel.setStringValue(columnSpec.getName());
                break;
            }
        }
        ArrayList<DataColumnSpec> outColumnSpecs = new ArrayList<DataColumnSpec>();
        for (DataColumnSpec inColumnSpec : inSpecs[0]) {
            outColumnSpecs.add(inColumnSpec);
        }
        if (this.appendReplaceChooserSettingsModel.getStringValue().equals("Append")) {
            String columnName = this.appendColumnNameInputSettingsModel.getStringValue();
            outColumnSpecs.add(new DataColumnSpecCreator(columnName, DataType.getType(DoubleCell.class)).createSpec());
        }
        return new DataTableSpec[]{new DataTableSpec(outColumnSpecs.toArray(new DataColumnSpec[outColumnSpecs.size()]))};
    }

    public void setExecutor(Execution executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Invalid argument for parameter executor: null");
        }
        this.executor = executor;
    }
}

