/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.timestamp;

import de.cyface.knime.nodes.timestamp.Execution;
import de.cyface.knime.nodes.timestamp.InputData;
import de.cyface.knime.nodes.timestamp.MissingCellException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.NodeLogger;

public class ExecutionWithoutAlignment
implements Execution {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ExecutionWithoutAlignment.class);

    @Override
    public BufferedDataTable[] execute(InputData input, DataTableSpec outputTableSpec, ExecutionContext context) throws CanceledExecutionException {
        DataTable firstTable = input.getFirstTable();
        DataTable secondTable = input.getSecondTable();
        String firstTimestampColumnName = input.getFirstTimestampColumnName();
        String secondTimestampColumnName = input.getSecondTimestampColumnName();
        DataTableSpec secondTableSpec = secondTable.getDataTableSpec();
        DataTableSpec firstTableSpec = firstTable.getDataTableSpec();
        BufferedDataContainer res = context.createDataContainer(outputTableSpec);
        RowIterator secondTableIter = secondTable.iterator();
        int secondTableTimestampColumnIndex = secondTableSpec.findColumnIndex(secondTimestampColumnName);
        int firstTableTimestampColumnIndex = firstTableSpec.findColumnIndex(firstTimestampColumnName);
        long firstTableAlignment = this.calcTableAlignment(firstTable, firstTimestampColumnName);
        long secondTableAlignment = this.calcTableAlignment(secondTable, secondTimestampColumnName);
        DataRow currentSecondTableRow = this.getNextValidRow(secondTableTimestampColumnIndex, secondTableIter);
        DataRow nextSecondTableRow = this.getNextValidRow(secondTableTimestampColumnIndex, secondTableIter);
        if (currentSecondTableRow == null) {
            LOGGER.warn((Object)"Not enough low frequency data to align to!");
        } else {
            try {
                long currentSecondTableTimestamp = ExecutionWithoutAlignment.align(this.getTimestamp(secondTimestampColumnName, currentSecondTableRow, secondTableTimestampColumnIndex), secondTableAlignment);
                long nextSecondTableTimestamp = nextSecondTableRow == null ? Long.MAX_VALUE : ExecutionWithoutAlignment.align(this.getTimestamp(secondTimestampColumnName, nextSecondTableRow, secondTableTimestampColumnIndex), secondTableAlignment);
                ExecutionMonitor monitor = context.createSubProgress(1.0);
                int i = 0;
                for (DataRow row : firstTable) {
                    long timestamp;
                    block11: {
                        context.checkCanceled();
                        timestamp = ExecutionWithoutAlignment.align(this.getTimestamp(firstTimestampColumnName, row, firstTableTimestampColumnIndex), firstTableAlignment);
                        if (timestamp >= currentSecondTableTimestamp || timestamp >= nextSecondTableTimestamp) break block11;
                        monitor.setProgress((double)i / (double)((BufferedDataTable)firstTable).size());
                        ++i;
                        continue;
                    }
                    try {
                        try {
                            if (nextSecondTableRow != null && timestamp >= nextSecondTableTimestamp) {
                                currentSecondTableRow = nextSecondTableRow;
                                currentSecondTableTimestamp = nextSecondTableTimestamp;
                                nextSecondTableRow = this.getNextValidRow(secondTableTimestampColumnIndex, secondTableIter);
                                nextSecondTableTimestamp = nextSecondTableRow == null ? Long.MAX_VALUE : ExecutionWithoutAlignment.align(this.getTimestamp(secondTimestampColumnName, nextSecondTableRow, secondTableTimestampColumnIndex), secondTableAlignment);
                            }
                            DataRow combinedRow = this.concatenateRows(row, currentSecondTableRow, firstTableTimestampColumnIndex, secondTableTimestampColumnIndex, timestamp, currentSecondTableTimestamp);
                            res.addRowToTable(combinedRow);
                        }
                        catch (MissingCellException missingCellException) {
                            LOGGER.warn((Object)("Skipping missing cell in row " + row.getKey()));
                            monitor.setProgress((double)i / (double)((BufferedDataTable)firstTable).size());
                            ++i;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.setProgress((double)i / (double)((BufferedDataTable)firstTable).size());
                        ++i;
                        throw throwable;
                    }
                    monitor.setProgress((double)i / (double)((BufferedDataTable)firstTable).size());
                    ++i;
                }
            }
            catch (MissingCellException e) {
                throw new IllegalStateException(e);
            }
        }
        res.close();
        return new BufferedDataTable[]{res.getTable()};
    }

    protected long calcTableAlignment(DataTable firstTable, String columnName) {
        return 0L;
    }

    static long align(long timestamp, long alignment) {
        return timestamp - alignment;
    }

    private DataRow getNextValidRow(int timestampColumnIndex, RowIterator iter) {
        while (iter.hasNext()) {
            DataRow row = iter.next();
            DataCell timestampCell = row.getCell(timestampColumnIndex);
            if (timestampCell.isMissing()) {
                LOGGER.warn((Object)("Skipping missing cell in row " + row.getKey()));
                continue;
            }
            return row;
        }
        return null;
    }

    private long getTimestamp(String columnName, DataRow row, int timestampColumnIndex) throws MissingCellException {
        DataCell timestampCell = row.getCell(timestampColumnIndex);
        if (timestampCell.isMissing()) {
            throw new MissingCellException();
        }
        if (timestampCell instanceof LongCell) {
            return ((LongCell)timestampCell).getLongValue();
        }
        if (row.getCell(timestampColumnIndex) instanceof IntCell) {
            return ((IntCell)timestampCell).getLongValue();
        }
        throw new IllegalStateException(String.format("{} column of invalid type {}. Pleas use a type compatible to long values.", columnName, row.getCell(timestampColumnIndex).getType().getName()));
    }

    private DataRow concatenateRows(DataRow firstRow, DataRow secondRow, int firstRowAlignmentCellIndex, int secondRowAlignmentCellIndex, long firstRowAlignedValue, long secondRowAlignedValue) {
        DataCell[] cells = new DataCell[firstRow.getNumCells() + secondRow.getNumCells()];
        int i = 0;
        for (DataCell cell : firstRow) {
            cells[i] = i == firstRowAlignmentCellIndex ? (cell.getClass().equals(LongCell.class) ? new LongCell(firstRowAlignedValue) : new IntCell((int)firstRowAlignedValue)) : cell;
            ++i;
        }
        int j = 0;
        for (DataCell cell : secondRow) {
            cells[i] = j == secondRowAlignmentCellIndex ? (cell.getClass().equals(LongCell.class) ? new LongCell(secondRowAlignedValue) : new IntCell((int)secondRowAlignedValue)) : cell;
            ++i;
            ++j;
        }
        return new DefaultRow(firstRow.getKey(), cells);
    }
}

