/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.export;

import de.cyface.knime.nodes.export.Point3DSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class ExportNodeModel
extends NodeModel {
    private static final short DATA_FORMAT_VERSION = 1;
    public static final int GEO_TABLE_INDEX = 0;
    public static final int ACCELERATION_TABLE_INDEX = 1;
    public static final int ROTATION_TABLE_INDEX = 2;
    public static final int DIRECTION_TABLE_INDEX = 3;
    public static final String OUTPUT_FILE_NAME_SETTING = "de.cyface.cfgkey.output";
    private final SettingsModelString outputFileNameSetting = new SettingsModelString("de.cyface.cfgkey.output", "");
    public static final String ACC_TIME_COL_SETTING = "de.cyface.cfgkey.acc_time_col";
    private final SettingsModelString accTimeColSetting = new SettingsModelString("de.cyface.cfgkey.acc_time_col", "");
    public static final String ACC_X_COL_SETTING = "de.cyface.cfgkey.acc_x_col";
    private final SettingsModelString accXColSetting = new SettingsModelString("de.cyface.cfgkey.acc_x_col", "");
    public static final String ACC_Y_COL_SETTING = "de.cyface.cfgkey.acc_y_col";
    private final SettingsModelString accYColSetting = new SettingsModelString("de.cyface.cfgkey.acc_y_col", "");
    public static final String ACC_Z_COL_SETTING = "de.cyface.cfgkey.acc_z_col";
    private final SettingsModelString accZColSetting = new SettingsModelString("de.cyface.cfgkey.acc_z_col", "");
    public static final String ROT_TIME_COL_SETTING = "de.cyface.cfgkey.rot_time_col";
    private final SettingsModelString rotTimeColSetting = new SettingsModelString("de.cyface.cfgkey.rot_time_col", "");
    public static final String ROT_X_COL_SETTING = "de.cyface.cfgkey.rot_x_col";
    private final SettingsModelString rotXColSetting = new SettingsModelString("de.cyface.cfgkey.rot_x_col", "");
    public static final String ROT_Y_COL_SETTING = "de.cyface.cfgkey.rot_y_col";
    private final SettingsModelString rotYColSetting = new SettingsModelString("de.cyface.cfgkey.rot_y_col", "");
    public static final String ROT_Z_COL_SETTING = "de.cyface.cfgkey.rot_z_col";
    private final SettingsModelString rotZColSetting = new SettingsModelString("de.cyface.cfgkey.rot_z_col", "");
    public static final String DIR_TIME_COL_SETTING = "de.cyface.cfgkey.dir_time_col";
    private final SettingsModelString dirTimeColSetting = new SettingsModelString("de.cyface.cfgkey.dir_time_col", "");
    public static final String DIR_X_COL_SETTING = "de.cyface.cfgkey.dir_x_col";
    private final SettingsModelString dirXColSetting = new SettingsModelString("de.cyface.cfgkey.dir_x_col", "");
    public static final String DIR_Y_COL_SETTING = "de.cyface.cfgkey.dir_y_col";
    private final SettingsModelString dirYColSetting = new SettingsModelString("de.cyface.cfgkey.dir_y_col", "");
    public static final String DIR_Z_COL_SETTING = "de.cyface.cfgkey.dir_z_col";
    private final SettingsModelString dirZColSetting = new SettingsModelString("de.cyface.cfgkey.dir_z_col", "");
    public static final String GEO_TIME_COL_SETTING = "de.cyface.cfgkey.geo_time_col";
    private final SettingsModelString geoTimeColSetting = new SettingsModelString("de.cyface.cfgkey.geo_time_col", "");
    public static final String GEO_LAT_COL_SETTING = "de.cyface.cfgkey.geo_lat_col";
    private final SettingsModelString geoLatColSetting = new SettingsModelString("de.cyface.cfgkey.geo_lat_col", "");
    public static final String GEO_LON_COL_SETTING = "de.cyface.cfgkey.geo_lon_col";
    private final SettingsModelString geoLonColSetting = new SettingsModelString("de.cyface.cfgkey.geo_lon_col", "");
    public static final String GEO_SPEED_COL_SETTING = "de.cyface.cfgkey.geo_speed_col";
    private final SettingsModelString geoSpeedColSetting = new SettingsModelString("de.cyface.cfgkey.geo_speed_col", "");
    public static final String GEO_ACCURACY_COL_SETTING = "de.cyface.cfgkey.geo_accuracy_col";
    private final SettingsModelString geoAccuracyColSetting = new SettingsModelString("de.cyface.cfgkey.geo_accuracy_col", "");

    public ExportNodeModel() {
        super(4, 0);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.outputFileNameSetting.saveSettingsTo(settings);
        this.accTimeColSetting.saveSettingsTo(settings);
        this.accXColSetting.saveSettingsTo(settings);
        this.accYColSetting.saveSettingsTo(settings);
        this.accZColSetting.saveSettingsTo(settings);
        this.rotTimeColSetting.saveSettingsTo(settings);
        this.rotXColSetting.saveSettingsTo(settings);
        this.rotYColSetting.saveSettingsTo(settings);
        this.rotZColSetting.saveSettingsTo(settings);
        this.dirTimeColSetting.saveSettingsTo(settings);
        this.dirXColSetting.saveSettingsTo(settings);
        this.dirYColSetting.saveSettingsTo(settings);
        this.dirZColSetting.saveSettingsTo(settings);
        this.geoTimeColSetting.saveSettingsTo(settings);
        this.geoLatColSetting.saveSettingsTo(settings);
        this.geoLonColSetting.saveSettingsTo(settings);
        this.geoSpeedColSetting.saveSettingsTo(settings);
        this.geoAccuracyColSetting.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.outputFileNameSetting.validateSettings(settings);
        this.accTimeColSetting.validateSettings(settings);
        this.accXColSetting.validateSettings(settings);
        this.accYColSetting.validateSettings(settings);
        this.accZColSetting.validateSettings(settings);
        this.rotTimeColSetting.validateSettings(settings);
        this.rotXColSetting.validateSettings(settings);
        this.rotYColSetting.validateSettings(settings);
        this.rotZColSetting.validateSettings(settings);
        this.dirTimeColSetting.validateSettings(settings);
        this.dirXColSetting.validateSettings(settings);
        this.dirYColSetting.validateSettings(settings);
        this.dirZColSetting.validateSettings(settings);
        this.geoTimeColSetting.validateSettings(settings);
        this.geoLatColSetting.validateSettings(settings);
        this.geoLonColSetting.validateSettings(settings);
        this.geoSpeedColSetting.validateSettings(settings);
        this.geoAccuracyColSetting.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.outputFileNameSetting.loadSettingsFrom(settings);
        this.accTimeColSetting.loadSettingsFrom(settings);
        this.accXColSetting.loadSettingsFrom(settings);
        this.accYColSetting.loadSettingsFrom(settings);
        this.accZColSetting.loadSettingsFrom(settings);
        this.rotTimeColSetting.loadSettingsFrom(settings);
        this.rotXColSetting.loadSettingsFrom(settings);
        this.rotYColSetting.loadSettingsFrom(settings);
        this.rotZColSetting.loadSettingsFrom(settings);
        this.dirTimeColSetting.loadSettingsFrom(settings);
        this.dirXColSetting.loadSettingsFrom(settings);
        this.dirYColSetting.loadSettingsFrom(settings);
        this.dirZColSetting.loadSettingsFrom(settings);
        this.geoTimeColSetting.loadSettingsFrom(settings);
        this.geoLatColSetting.loadSettingsFrom(settings);
        this.geoLonColSetting.loadSettingsFrom(settings);
        this.geoSpeedColSetting.loadSettingsFrom(settings);
        this.geoAccuracyColSetting.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable geoLocationsTable = inData[0];
        BufferedDataTable accelerationsTable = inData[1];
        final DataTableSpec accelerationsTableSpec = inData[1].getDataTableSpec();
        BufferedDataTable rotationsTable = inData[2];
        final DataTableSpec rotationsTableSpec = inData[2].getDataTableSpec();
        BufferedDataTable directionsTable = inData[3];
        final DataTableSpec directionsTableSpec = inData[3].getDataTableSpec();
        byte[] header = this.createHeader((int)geoLocationsTable.size(), (int)accelerationsTable.size(), (int)rotationsTable.size(), (int)directionsTable.size());
        long itemsToProcess = geoLocationsTable.size() + accelerationsTable.size() + rotationsTable.size() + directionsTable.size();
        byte[] geoLocations = this.serializeGeoLocations(geoLocationsTable, exec, itemsToProcess);
        byte[] accelerations = new Point3DSerializer(){

            @Override
            protected int getZColumnIndex() {
                return accelerationsTableSpec.findColumnIndex(ExportNodeModel.this.accZColSetting.getStringValue());
            }

            @Override
            protected int getYColumnIndex() {
                return accelerationsTableSpec.findColumnIndex(ExportNodeModel.this.accYColSetting.getStringValue());
            }

            @Override
            protected int getXColumnIndex() {
                return accelerationsTableSpec.findColumnIndex(ExportNodeModel.this.accXColSetting.getStringValue());
            }

            @Override
            protected int getTimestampColumnIndex() {
                return accelerationsTableSpec.findColumnIndex(ExportNodeModel.this.accTimeColSetting.getStringValue());
            }
        }.serialize(accelerationsTable, exec, itemsToProcess);
        byte[] rotations = new Point3DSerializer(){

            @Override
            protected int getXColumnIndex() {
                return rotationsTableSpec.findColumnIndex(ExportNodeModel.this.rotXColSetting.getStringValue());
            }

            @Override
            protected int getYColumnIndex() {
                return rotationsTableSpec.findColumnIndex(ExportNodeModel.this.rotYColSetting.getStringValue());
            }

            @Override
            protected int getZColumnIndex() {
                return rotationsTableSpec.findColumnIndex(ExportNodeModel.this.rotZColSetting.getStringValue());
            }

            @Override
            protected int getTimestampColumnIndex() {
                return rotationsTableSpec.findColumnIndex(ExportNodeModel.this.rotTimeColSetting.getStringValue());
            }
        }.serialize(rotationsTable, exec, itemsToProcess);
        byte[] directions = new Point3DSerializer(){

            @Override
            protected int getZColumnIndex() {
                return directionsTableSpec.findColumnIndex(ExportNodeModel.this.dirZColSetting.getStringValue());
            }

            @Override
            protected int getYColumnIndex() {
                return directionsTableSpec.findColumnIndex(ExportNodeModel.this.dirYColSetting.getStringValue());
            }

            @Override
            protected int getXColumnIndex() {
                return directionsTableSpec.findColumnIndex(ExportNodeModel.this.dirXColSetting.getStringValue());
            }

            @Override
            protected int getTimestampColumnIndex() {
                return directionsTableSpec.findColumnIndex(ExportNodeModel.this.dirTimeColSetting.getStringValue());
            }
        }.serialize(directionsTable, exec, itemsToProcess);
        ByteBuffer buffer = ByteBuffer.allocate(header.length + geoLocations.length + accelerations.length + rotations.length + directions.length);
        buffer.put(header);
        buffer.put(geoLocations);
        buffer.put(accelerations);
        buffer.put(rotations);
        buffer.put(directions);
        Throwable throwable = null;
        Object var19_19 = null;
        try (FileOutputStream dataWriter = new FileOutputStream(this.outputFileNameSetting.getStringValue());){
            ((OutputStream)dataWriter).write(buffer.array());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new BufferedDataTable[0];
    }

    private byte[] createHeader(int countOfGeoLocations, int countOfAccelerations, int countOfRotations, int countOfDirections) {
        byte[] ret = new byte[]{0, 1, (byte)(countOfGeoLocations >> 24), (byte)(countOfGeoLocations >> 16), (byte)(countOfGeoLocations >> 8), (byte)countOfGeoLocations, (byte)(countOfAccelerations >> 24), (byte)(countOfAccelerations >> 16), (byte)(countOfAccelerations >> 8), (byte)countOfAccelerations, (byte)(countOfRotations >> 24), (byte)(countOfRotations >> 16), (byte)(countOfRotations >> 8), (byte)countOfRotations, (byte)(countOfDirections >> 24), (byte)(countOfDirections >> 16), (byte)(countOfDirections >> 8), (byte)countOfDirections};
        return ret;
    }

    private byte[] serializeGeoLocations(BufferedDataTable geoLocationsTable, ExecutionContext context, long itemsToProcess) throws CanceledExecutionException {
        ByteBuffer buffer = ByteBuffer.allocate((int)geoLocationsTable.size() * 36);
        DataTableSpec geoLocationsSpec = geoLocationsTable.getDataTableSpec();
        ExecutionMonitor monitor = context.createSubProgress((double)geoLocationsTable.size() / (double)itemsToProcess);
        double processedItems = 0.0;
        for (DataRow row : geoLocationsTable) {
            context.checkCanceled();
            monitor.setProgress(processedItems / (double)itemsToProcess);
            buffer.putLong(((LongCell)row.getCell(geoLocationsSpec.findColumnIndex(this.geoTimeColSetting.getStringValue()))).getLongValue());
            buffer.putDouble(((DoubleCell)row.getCell(geoLocationsSpec.findColumnIndex(this.geoLatColSetting.getStringValue()))).getDoubleValue());
            buffer.putDouble(((DoubleCell)row.getCell(geoLocationsSpec.findColumnIndex(this.geoLonColSetting.getStringValue()))).getDoubleValue());
            buffer.putDouble(((DoubleCell)row.getCell(geoLocationsSpec.findColumnIndex(this.geoSpeedColSetting.getStringValue()))).getDoubleValue());
            buffer.putInt(((IntCell)row.getCell(geoLocationsSpec.findColumnIndex(this.geoAccuracyColSetting.getStringValue()))).getIntValue());
        }
        byte[] payload = new byte[buffer.capacity()];
        ((ByteBuffer)buffer.duplicate().clear()).get(payload);
        return payload;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[0];
    }
}

