/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.timestamp;

import de.cyface.knime.nodes.timestamp.ExecutionWithoutAlignment;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.IntValue;
import org.knime.core.data.LongValue;

public final class ExecutionWithAlignment
extends ExecutionWithoutAlignment {
    @Override
    protected long calcTableAlignment(DataTable table, String columnName) {
        long min = Long.MAX_VALUE;
        int valueColumnIndex = table.getDataTableSpec().findColumnIndex(columnName);
        for (DataRow row : table) {
            DataCell cell = row.getCell(valueColumnIndex);
            min = cell.getType().isCompatible(LongValue.class) ? this.findMin(min, (LongValue)LongValue.class.cast(cell)) : this.findMin(min, (IntValue)IntValue.class.cast(cell));
        }
        return min;
    }

    protected long findMin(long currentMin, LongValue cell) {
        long cellValue = cell.getLongValue();
        return cellValue < currentMin ? cellValue : currentMin;
    }

    protected long findMin(long currentMin, IntValue cell) {
        return this.findMin(currentMin, cell);
    }
}

