/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.timestamp;

import de.cyface.knime.nodes.timestamp.ExecutionWithAlignment;
import de.cyface.knime.nodes.timestamp.ExecutionWithoutAlignment;
import de.cyface.knime.nodes.timestamp.InputData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.LongValue;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class TimestampAlignerNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(TimestampAlignerNodeModel.class);
    private final SettingsModelString firstTimestampColumnName = new SettingsModelString("de.cyface.knime.firsttablecolumnname", "");
    private final SettingsModelBoolean firstTimestampColumnRenameCheckbox = new SettingsModelBoolean("de.cyface.knime.firsttablerenamecheckbox", false);
    private final SettingsModelString firstTimestampColumnRenameName = new SettingsModelString("de.cyface.knime.firsttablerename", "");
    private final SettingsModelString secondTimestampColumnName = new SettingsModelString("de.cyface.knime.secondtablecolumnname", "");
    private final SettingsModelBoolean secondTimestampColumnRenameCheckbox = new SettingsModelBoolean("de.cyface.knime.secondtablerenamecheckbox", false);
    private final SettingsModelString secondTimestampColumnRenameName = new SettingsModelString("de.cyface.knime.secondtablerename", "");
    private final SettingsModelBoolean valueRangeAlignment = new SettingsModelBoolean("de.cyface.knime.valuerangealignment", false);
    static final String CFGKEY_FIRST_TABLE_COLUMN_NAME = "de.cyface.knime.firsttablecolumnname";
    static final String CFGKEY_RENAME_FIRST_TABLE_COLUMN_CHECKBOX = "de.cyface.knime.firsttablerenamecheckbox";
    static final String CFGKEY_RENAME_FIRST_TABLE_COLUMN_NAME = "de.cyface.knime.firsttablerename";
    static final String CFGKEY_SECOND_TABLE_COLUMN_NAME = "de.cyface.knime.secondtablecolumnname";
    static final String CFGKEY_RENAME_SECOND_TABLE_COLUMN_CHECKBOX = "de.cyface.knime.secondtablerenamecheckbox";
    static final String CFGKEY_RENAME_SECOND_TABLE_COLUMN_NAME = "de.cyface.knime.secondtablerename";
    static final String CFGKEY_VALUE_RANGE_ALIGNMENT_NAME = "de.cyface.knime.valuerangealignment";
    static final int FIRST_IN_PORT = 0;
    static final int SECOND_IN_PORT = 1;

    protected TimestampAlignerNodeModel() {
        super(2, 1);
        this.firstTimestampColumnRenameCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimestampAlignerNodeModel.this.firstTimestampColumnRenameName.setEnabled(TimestampAlignerNodeModel.this.firstTimestampColumnRenameCheckbox.getBooleanValue());
            }
        });
        this.secondTimestampColumnRenameCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimestampAlignerNodeModel.this.secondTimestampColumnRenameName.setEnabled(TimestampAlignerNodeModel.this.secondTimestampColumnRenameCheckbox.getBooleanValue());
            }
        });
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        try {
            BufferedDataTable firstTable = inData[0];
            BufferedDataTable secondTable = inData[1];
            InputData input = new InputData((DataTable)firstTable, (DataTable)secondTable, this.firstTimestampColumnName.getStringValue(), this.secondTimestampColumnName.getStringValue());
            if (this.valueRangeAlignment.getBooleanValue()) {
                return new ExecutionWithAlignment().execute(input, this.createResultSpec(firstTable.getDataTableSpec(), secondTable.getDataTableSpec()), exec);
            }
            return new ExecutionWithoutAlignment().execute(input, this.createResultSpec(firstTable.getDataTableSpec(), secondTable.getDataTableSpec()), exec);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec firstTable = inSpecs[0];
        DataTableSpec secondTable = inSpecs[1];
        this.checkForValidTimestampColumn(firstTable, this.firstTimestampColumnName.getStringValue());
        this.checkForValidTimestampColumn(secondTable, this.secondTimestampColumnName.getStringValue());
        return new DataTableSpec[]{this.createResultSpec(firstTable, secondTable)};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.firstTimestampColumnName.saveSettingsTo(settings);
        this.secondTimestampColumnName.saveSettingsTo(settings);
        this.valueRangeAlignment.saveSettingsTo(settings);
        this.firstTimestampColumnRenameCheckbox.saveSettingsTo(settings);
        this.firstTimestampColumnRenameName.saveSettingsTo(settings);
        this.secondTimestampColumnRenameCheckbox.saveSettingsTo(settings);
        this.secondTimestampColumnRenameName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.firstTimestampColumnName.loadSettingsFrom(settings);
        this.secondTimestampColumnName.loadSettingsFrom(settings);
        this.valueRangeAlignment.loadSettingsFrom(settings);
        this.firstTimestampColumnRenameCheckbox.loadSettingsFrom(settings);
        this.firstTimestampColumnRenameName.loadSettingsFrom(settings);
        this.secondTimestampColumnRenameCheckbox.loadSettingsFrom(settings);
        this.secondTimestampColumnRenameName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.firstTimestampColumnName.validateSettings(settings);
        this.secondTimestampColumnName.validateSettings(settings);
        this.valueRangeAlignment.validateSettings(settings);
        this.firstTimestampColumnRenameCheckbox.validateSettings(settings);
        this.firstTimestampColumnRenameName.validateSettings(settings);
        this.secondTimestampColumnRenameCheckbox.validateSettings(settings);
        this.secondTimestampColumnRenameName.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    private DataTableSpec createResultSpec(DataTableSpec firstTableSpec, DataTableSpec secondTableSpec) {
        DataColumnSpec[] colSpecs = new DataColumnSpec[firstTableSpec.getNumColumns() + secondTableSpec.getNumColumns()];
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        int i = 0;
        while (i < firstTableSpec.getNumColumns()) {
            colSpecs[i] = this.getColumnSpec(firstTableSpec, i, names);
            ++i;
        }
        while (i < firstTableSpec.getNumColumns() + secondTableSpec.getNumColumns()) {
            colSpecs[i] = this.getColumnSpec(secondTableSpec, i - firstTableSpec.getNumColumns(), names);
            ++i;
        }
        this.renameOutputColumnsIfNecessary(colSpecs, firstTableSpec, secondTableSpec);
        return new DataTableSpec(colSpecs);
    }

    private void renameOutputColumnsIfNecessary(DataColumnSpec[] colSpecs, DataTableSpec firstTableSpec, DataTableSpec secondTableSpec) {
        int offset = 0;
        if (this.firstTimestampColumnRenameCheckbox.getBooleanValue()) {
            offset = this.renameColumn(firstTableSpec, this.firstTimestampColumnName.getStringValue(), this.firstTimestampColumnRenameName.getStringValue(), colSpecs, offset);
        }
        if (this.secondTimestampColumnRenameCheckbox.getBooleanValue()) {
            offset = this.renameColumn(secondTableSpec, this.secondTimestampColumnName.getStringValue(), this.secondTimestampColumnRenameName.getStringValue(), colSpecs, offset);
        }
    }

    private int renameColumn(DataTableSpec tableSpec, String originalColumnName, String renamedColumnName, DataColumnSpec[] colSpecs, int offset) {
        int indexOfFirstTimestampColumnInFirstInputSpec = offset + tableSpec.findColumnIndex(originalColumnName);
        DataType type = colSpecs[indexOfFirstTimestampColumnInFirstInputSpec].getType();
        colSpecs[indexOfFirstTimestampColumnInFirstInputSpec] = new DataColumnSpecCreator(renamedColumnName, type).createSpec();
        return tableSpec.getNumColumns();
    }

    private void checkForValidTimestampColumn(DataTableSpec tableSpec, String columnName) throws InvalidSettingsException {
        if (!tableSpec.containsName(columnName) || !tableSpec.getColumnSpec(columnName).getType().isCompatible(LongValue.class)) {
            throw new InvalidSettingsException(String.format("No valid timestamp column called %s in table %s", columnName, tableSpec.getName()));
        }
    }

    private DataColumnSpec getColumnSpec(DataTableSpec tableSpec, int columnSpecIndex, Map<String, Integer> names) {
        DataColumnSpec columnSpec = tableSpec.getColumnSpec(columnSpecIndex);
        Integer counter = names.get(columnSpec.getName());
        if (counter == null) {
            counter = 1;
        } else {
            DataColumnSpec qualifiedSpec;
            String qualifiedName = counter + "_" + columnSpec.getName();
            columnSpec = qualifiedSpec = new DataColumnSpecCreator(qualifiedName, columnSpec.getType()).createSpec();
            counter = counter + 1;
        }
        names.put(columnSpec.getName(), counter);
        return columnSpec;
    }
}

