/*
 * Decompiled with CFR 0.152.
 */
package de.cyface.knime.nodes.mapmatching;

import de.cyface.knime.dialog.ColumnSelectionNodeOption;
import de.cyface.knime.dialog.StringSelectionNodeOption;
import de.cyface.knime.dialog.TextFieldNodeOption;
import de.cyface.knime.nodes.mapmatching.MapMatchingNodeDialog;
import de.cyface.knime.nodes.mapmatching.MapMatchingNodeModel;
import de.cyface.knime.nodes.mapmatching.MapMatchingNodeView;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.IntValue;
import org.knime.core.data.LongValue;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeFactory;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public final class MapMatchingNodeFactory
extends NodeFactory<MapMatchingNodeModel> {
    private final StringSelectionNodeOption mapMatchingFrameworkOption;
    private final TextFieldNodeOption serverAddressInputOption;
    private final TextFieldNodeOption serverPortInputOption;
    private final TextFieldNodeOption databaseNameInputOption;
    private final TextFieldNodeOption databaseTableInputOption;
    private final TextFieldNodeOption databaseUserInputOption;
    private final TextFieldNodeOption databasePasswordInputOption;
    private final TextFieldNodeOption databaseRoadTypesInputOption;
    private final ColumnSelectionNodeOption latInputColumnSelector;
    private final ColumnSelectionNodeOption lonInputColumnSelector;
    private final ColumnSelectionNodeOption headingInputColumnSelector;
    private final ColumnSelectionNodeOption idInputColumnSelector;
    private final ColumnSelectionNodeOption timestampInputColumnSelector;

    public MapMatchingNodeFactory() {
        String roadTypes = ((Object)((Object)this)).getClass().getResource("/road-types.json").getFile();
        this.mapMatchingFrameworkOption = new StringSelectionNodeOption("de.cyface.mapmatching.id.framework", "Select Framework to use", 0, "Barefoot");
        this.serverAddressInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.server.address", "Provide Matching Server Address", "localhost");
        this.serverPortInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.server.port", "Provide Matching Server Port", "5432");
        this.databaseNameInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.database.name", "Provide name of database with matching data", "sachsen");
        this.databaseTableInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.database.table", "Provide name of database table", "bfmap_ways");
        this.databaseUserInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.database.user", "Provide user with access to matching data table", "osmuser");
        this.databasePasswordInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.database.password", "Provide password for user with access to matching data table", "pass");
        this.databaseRoadTypesInputOption = new TextFieldNodeOption("de.cyface.mapmatching.id.database.road-types", "Provide path of configuration file for road type priority", roadTypes);
        this.latInputColumnSelector = new ColumnSelectionNodeOption("de.cyface.mapmatching.id.latinput", "Latitude Column", DoubleValue.class);
        this.lonInputColumnSelector = new ColumnSelectionNodeOption("de.cyface.mapmatching.id.loninput", "Longitude Column", DoubleValue.class);
        this.headingInputColumnSelector = new ColumnSelectionNodeOption("de.cyface.mapmatching.id.headinginput", "Heading Column (Optional)", DoubleValue.class);
        this.idInputColumnSelector = new ColumnSelectionNodeOption("de.cyface.mapmatching.id.idinput", "Identifier Column");
        this.timestampInputColumnSelector = new ColumnSelectionNodeOption("de.cyface.mapmatching.id.timestampinput", "Timestamp Column", LongValue.class, IntValue.class);
    }

    public MapMatchingNodeModel createNodeModel() {
        return new MapMatchingNodeModel(this.mapMatchingFrameworkOption.getSettingsModel(), this.serverAddressInputOption.getSettingsModel(), this.serverPortInputOption.getSettingsModel(), this.databaseNameInputOption.getSettingsModel(), this.databaseTableInputOption.getSettingsModel(), this.databaseUserInputOption.getSettingsModel(), this.databasePasswordInputOption.getSettingsModel(), this.databaseRoadTypesInputOption.getSettingsModel(), this.latInputColumnSelector.getSettingsModel(), this.lonInputColumnSelector.getSettingsModel(), this.headingInputColumnSelector.getSettingsModel(), this.idInputColumnSelector.getSettingsModel(), new SettingsModelString("de.cyface.mapmatching.id.timestampinput", ""));
    }

    protected int getNrNodeViews() {
        return 0;
    }

    public MapMatchingNodeView createNodeView(int viewIndex, MapMatchingNodeModel nodeModel) {
        return null;
    }

    protected boolean hasDialog() {
        return true;
    }

    protected NodeDialogPane createNodeDialogPane() {
        return new MapMatchingNodeDialog(this.mapMatchingFrameworkOption, this.serverAddressInputOption, this.serverPortInputOption, this.databaseNameInputOption, this.databaseTableInputOption, this.databaseUserInputOption, this.databasePasswordInputOption, this.databaseRoadTypesInputOption, this.latInputColumnSelector, this.lonInputColumnSelector, this.headingInputColumnSelector, this.idInputColumnSelector, this.timestampInputColumnSelector);
    }
}

