/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2;

import com.nodepit.nodes.deepl.v2.ResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.migration.ConfigMigration;
import org.knime.node.parameters.migration.NodeParametersMigration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.widget.choices.StringChoice;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

public final class NodeParametersUtils {
    private NodeParametersUtils() {
    }

    public static abstract class BooleanChoicesPersistor
    implements NodeParametersPersistor<String> {
        public String load(NodeSettingsRO settings) throws InvalidSettingsException {
            return Boolean.toString(settings.getBoolean(this.getConfigKey()));
        }

        public void save(String obj, NodeSettingsWO settings) {
            settings.addBoolean(this.getConfigKey(), Boolean.parseBoolean(obj));
        }

        public String[][] getConfigPaths() {
            return new String[][]{{this.getConfigKey()}};
        }

        public abstract String getConfigKey();
    }

    public static final class BooleanChoicesProvider
    implements StringChoicesProvider {
        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }

    public static abstract class ResponseMapperChoicesProvider
    implements StringChoicesProvider {
        public List<StringChoice> computeState(NodeParametersInput context) {
            return Arrays.stream(this.getResponseMappers()).map(m -> new StringChoice(m.identifier(), m.label())).toList();
        }

        public abstract ResponseMapper[] getResponseMappers();
    }

    public static final class ResponseMapperMigration
    implements NodeParametersMigration<String> {
        public List<ConfigMigration<String>> getConfigMigrations() {
            return Arrays.asList(ConfigMigration.builder(settings -> "raw_response").withMatcher(t -> t.getString("resultFormat", null) == null).build());
        }
    }
}

