/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.createglossary;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class CreateGlossaryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Name", description="Name to be associated with the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String name = null;
    @Widget(title="Source Language", description="The language in which the source texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Target Language", description="The language in which the target texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Entries", description="The entries of the glossary. The entries have to be specified in the format provided by the <tt>entries_format</tt> parameter.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String entries = null;
    @Widget(title="Entries Format", description="\t<p>The format in which the glossary entries are provided. Formats currently available:</p>\n<ul>\n<li><tt>tsv</tt> (default) - tab-separated values</li>\n<li><tt>csv</tt> - comma-separated values</li>\n</ul>\n<p>See <a href=\"https://www.deepl.com/docs-api/glossaries/formats\">Supported Glossary Formats</a> for details about each format.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Entries_FormatChoicesProvider.class)
    String entriesFormat = "tsv";
    private static final String[] ENTRIES_FORMAT_VALUES = new String[]{"tsv", "csv"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Glossary ID:</b> A unique ID assigned to a glossary.</li>\n\t\t<li><b>Name:</b> Name associated with the glossary.</li>\n\t\t<li><b>Ready:</b> Indicates if the newly created glossary can already be used in <tt>translate</tt> requests.\nIf the created glossary is not yet ready, you have to wait and check the <tt>ready</tt> status\nof the glossary before using it in a <tt>translate</tt> request.</li>\n\t\t<li><b>Source Language:</b> The language in which the source texts in the glossary are specified.</li>\n\t\t<li><b>Target Language:</b> The language in which the target texts in the glossary are specified.</li>\n\t\t<li><b>Creation Time:</b> The creation time of the glossary in the ISO 8601-1:2019 format (e.g.: <tt>2021-08-03T14:16:18.329Z</tt>).</li>\n\t\t<li><b>Entry Count:</b> The number of entries in the glossary.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateGlossaryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"glossary_id\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"ready\":\"rows[0][2]\",\"source_lang\":\"rows[0][3]\",\"target_lang\":\"rows[0][4]\",\"creation_time\":\"rows[0][5]\",\"entry_count\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Glossary ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Ready", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Target Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Creation Time", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entry Count", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    CreateGlossaryNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.name == null || this.name.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cName\u201d is required.");
        }
        if (this.sourceLang == null || this.sourceLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSource Language\u201d is required.");
        }
        if (this.targetLang == null || this.targetLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Language\u201d is required.");
        }
        if (this.entries == null || this.entries.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEntries\u201d is required.");
        }
        if (this.entriesFormat == null || this.entriesFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEntries Format\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/v2/glossaries");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.FORM);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "name", this.name));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "source_lang", this.sourceLang));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "target_lang", this.targetLang));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "entries", this.entries));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "entries_format", this.entriesFormat));
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class CreateGlossaryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateGlossaryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Entries_FormatChoicesProvider
    implements StringChoicesProvider {
        private Entries_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ENTRIES_FORMAT_VALUES);
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }
}

