/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.deletedictionary;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class DeleteDictionaryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Source Language", description="The language in which the source texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Target Language", description="The language in which the target texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=DeleteDictionaryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};

    DeleteDictionaryNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.sourceLang == null || this.sourceLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSource Language\u201d is required.");
        }
        if (this.targetLang == null || this.targetLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Language\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("DELETE");
        builder.setPath("/v3/glossaries/{glossary_id}/dictionaries");
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.PATH, "glossary_id", this.glossaryId));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "source_lang", this.sourceLang));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "target_lang", this.targetLang));
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class DeleteDictionaryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private DeleteDictionaryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }
}

