/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.downloaddocument;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class DownloadDocumentNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Document ID", description="The document ID that was sent to the client when the document was uploaded to the API.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String documentId = null;
    @Widget(title="Document Key", description="The document encryption key that was sent to the client when the document was uploaded to the API.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String documentKey = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=DownloadDocumentNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    DownloadDocumentNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.documentId == null || this.documentId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDocument ID\u201d is required.");
        }
        if (this.documentKey == null || this.documentKey.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDocument Key\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/v2/document/{document_id}/result");
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.PATH, "document_id", this.documentId));
        builder.setBodyType(HttpRequestNodeParameters.BodyType.FORM);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "document_key", this.documentKey));
        builder.setResponseType("application/octet-stream");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class DownloadDocumentNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private DownloadDocumentNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

