/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getglossaryentries;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class GetGlossaryEntriesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Set Accept", description="Enable to set the optional field <b>Accept</b>")
    @ValueReference(value=AcceptEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean acceptEnabled = false;
    @Widget(title="Accept", description="The requested format of the returned glossary entries. Currently, supports only <tt>text/tab-separated-values</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AcceptEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=AcceptChoicesProvider.class)
    String accept = "text/tab-separated-values";
    private static final String[] ACCEPT_VALUES = new String[]{"text/tab-separated-values"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetGlossaryEntriesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    GetGlossaryEntriesNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("GET");
        builder.setPath("/v2/glossaries/{glossary_id}/entries");
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.PATH, "glossary_id", this.glossaryId));
        if (this.acceptEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.HEADER, "Accept", this.accept));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.setResponseType("text/tab-separated-values");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AcceptChoicesProvider
    implements StringChoicesProvider {
        private AcceptChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ACCEPT_VALUES);
        }
    }

    private static final class AcceptEnabledRef
    implements BooleanReference {
        private AcceptEnabledRef() {
        }
    }

    private static final class GetGlossaryEntriesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetGlossaryEntriesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

