/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getstylerulelists;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

final class GetStyleRuleListsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Page", description="Enable to set the optional field <b>Page</b>")
    @ValueReference(value=PageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageEnabled = false;
    @Widget(title="Page", description="The index of the first page to return. Use with <tt>page_size</tt> to get the next page of rule lists\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int page = 0;
    @Widget(title="Set Page Size", description="Enable to set the optional field <b>Page Size</b>")
    @ValueReference(value=PageSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageSizeEnabled = false;
    @Widget(title="Page Size", description="The maximum number of style rule lists to return.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Page_SizeMinValidation.class, maxValidation=Page_SizeMaxValidation.class)
    int pageSize = 10;
    @Widget(title="Set Detailed", description="Enable to set the optional field <b>Detailed</b>")
    @ValueReference(value=DetailedEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean detailedEnabled = false;
    @Widget(title="Detailed", description="Determines if the rule list's <tt>configured_rules</tt> and <tt>custom_instructions</tt> should be included in the response body.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DetailedEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=DetailedPersistor.class)
    String detailed = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetStyleRuleListsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    GetStyleRuleListsNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("GET");
        builder.setPath("/v3/style_rules");
        if (this.pageEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "page", this.page));
        }
        if (this.pageSizeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "page_size", this.pageSize));
        }
        if (this.detailedEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "detailed", this.detailed));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.NONE);
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class DetailedEnabledRef
    implements BooleanReference {
        private DetailedEnabledRef() {
        }
    }

    private static final class DetailedPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "detailed";

        private DetailedPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class GetStyleRuleListsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetStyleRuleListsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageEnabledRef
    implements BooleanReference {
        private PageEnabledRef() {
        }
    }

    private static final class PageSizeEnabledRef
    implements BooleanReference {
        private PageSizeEnabledRef() {
        }
    }

    private static final class Page_SizeMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Page_SizeMaxValidation() {
        }

        public double getMax() {
            return 25.0;
        }
    }

    private static final class Page_SizeMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Page_SizeMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }
}

