/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.rephrasetext;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class RephraseTextNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Text", description="Text to be improved. Only UTF-8-encoded plain text is supported. Improvements are returned in the same order as they are requested.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=TextPersistor.class)
    Text[] text = new Text[]{new Text(null)};
    @Widget(title="Set Target Language", description="Enable to set the optional field <b>Target Language</b>")
    @ValueReference(value=TargetLangEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean targetLangEnabled = false;
    @Widget(title="Target Language", description="\t<p>The language for the text improvement. Options currently available:</p>\n<ul>\n<li><tt>de</tt> - German</li>\n<li><tt>en</tt> - English (unspecified variant, defaults to <tt>en-US</tt>)</li>\n<li><tt>en-GB</tt> - English (British)</li>\n<li><tt>en-US</tt> - English (American)</li>\n<li><tt>es</tt> - Spanish</li>\n<li><tt>fr</tt> - French</li>\n<li><tt>it</tt> - Italian</li>\n<li><tt>pt</tt> - Portuguese (unspecified variant, defaults to <tt>pt-PT</tt>)</li>\n<li><tt>pt-BR</tt> - Portuguese (Brazilian)</li>\n<li><tt>pt-PT</tt> - Portuguese (all Portuguese variants excluding Brazilian Portuguese)</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TargetLangEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"de", "en", "en-GB", "en-US", "fr", "it", "pt", "pt-BR", "pt-PT"};
    @Widget(title="Set Writing Style", description="Enable to set the optional field <b>Writing Style</b>")
    @ValueReference(value=WritingStyleEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean writingStyleEnabled = false;
    @Widget(title="Writing Style", description="\tSpecify a style to rephrase your text in a way that fits your audience and goals.\nThe <tt>prefer_</tt> prefix allows falling back to the default style if the language does not yet support styles.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WritingStyleEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Writing_StyleChoicesProvider.class)
    String writingStyle = WRITING_STYLE_VALUES[0];
    private static final String[] WRITING_STYLE_VALUES = new String[]{"academic", "business", "casual", "default", "simple", "prefer_academic", "prefer_business", "prefer_casual", "prefer_simple"};
    @Widget(title="Set Tone", description="Enable to set the optional field <b>Tone</b>")
    @ValueReference(value=ToneEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean toneEnabled = false;
    @Widget(title="Tone", description="\tSpecify the desired tone for your text.\nThe <tt>prefer_</tt> prefix allows falling back to the default tone if the language does not yet support tones.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ToneEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=ToneChoicesProvider.class)
    String tone = TONE_VALUES[0];
    private static final String[] TONE_VALUES = new String[]{"confident", "default", "diplomatic", "enthusiastic", "friendly", "prefer_confident", "prefer_diplomatic", "prefer_enthusiastic", "prefer_friendly"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Detected Source Language:</b> The language detected in the source text.</li>\n\t<li><b>Text:</b> The improved text.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=RephraseTextNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"improvements\":{\"*\":{\"detected_source_language\":\"rows[#2][0]\",\"text\":\"rows[#2][1]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Detected Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    RephraseTextNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.text == null || this.text.length == 0) {
            throw new InvalidSettingsException("Value for \u201cText\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/v2/write/rephrase");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.FORM);
        Arrays.stream(this.text).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "text", value.text)));
        if (this.targetLangEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "target_lang", this.targetLang));
        }
        if (this.writingStyleEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "writing_style", this.writingStyle));
        }
        if (this.toneEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "tone", this.tone));
        }
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class RephraseTextNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private RephraseTextNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class TargetLangEnabledRef
    implements BooleanReference {
        private TargetLangEnabledRef() {
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }

    static final class Text
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Text() {
        }

        Text(String text) {
            this.text = text;
        }
    }

    private static final class TextPersistor
    implements NodeParametersPersistor<Text[]> {
        static final String CONFIG_KEY = "text";

        private TextPersistor() {
        }

        public Text[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Text[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Text::new).toArray(Text[]::new);
        }

        public void save(Text[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class ToneChoicesProvider
    implements StringChoicesProvider {
        private ToneChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TONE_VALUES);
        }
    }

    private static final class ToneEnabledRef
    implements BooleanReference {
        private ToneEnabledRef() {
        }
    }

    private static final class WritingStyleEnabledRef
    implements BooleanReference {
        private WritingStyleEnabledRef() {
        }
    }

    private static final class Writing_StyleChoicesProvider
    implements StringChoicesProvider {
        private Writing_StyleChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(WRITING_STYLE_VALUES);
        }
    }
}

