/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.replacedictionary;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class ReplaceDictionaryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Set Source Language", description="Enable to set the optional field <b>Source Language</b>")
    @ValueReference(value=SourceLangEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sourceLangEnabled = false;
    @Widget(title="Source Language", description="The language in which the source texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SourceLangEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Set Target Language", description="Enable to set the optional field <b>Target Language</b>")
    @ValueReference(value=TargetLangEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean targetLangEnabled = false;
    @Widget(title="Target Language", description="The language in which the target texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TargetLangEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Set Entries", description="Enable to set the optional field <b>Entries</b>")
    @ValueReference(value=EntriesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean entriesEnabled = false;
    @Widget(title="Entries", description="The entries of the glossary. The entries have to be specified in the format provided by the <tt>entries_format</tt> parameter.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=EntriesEnabledRef.class, type=Effect.EffectType.SHOW)
    String entries = null;
    @Widget(title="Set Entries Format", description="Enable to set the optional field <b>Entries Format</b>")
    @ValueReference(value=EntriesFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean entriesFormatEnabled = false;
    @Widget(title="Entries Format", description="\t<p>The format in which the glossary entries are provided. Formats currently available:</p>\n<ul>\n<li><tt>tsv</tt> (default) - tab-separated values</li>\n<li><tt>csv</tt> - comma-separated values</li>\n</ul>\n<p>See <a href=\"https://www.deepl.com/docs-api/glossaries/formats\">Supported Glossary Formats</a> for details about each format.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=EntriesFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Entries_FormatChoicesProvider.class)
    String entriesFormat = "tsv";
    private static final String[] ENTRIES_FORMAT_VALUES = new String[]{"tsv", "csv"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Source Language:</b> The language in which the source texts in the glossary are specified.</li>\n\t<li><b>Target Language:</b> The language in which the target texts in the glossary are specified.</li>\n\t<li><b>Entry Count:</b> The number of entries in the glossary.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ReplaceDictionaryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"source_lang\":\"rows[0][0]\",\"target_lang\":\"rows[0][1]\",\"entry_count\":\"rows[0][2]\"}}]").addBodyColumn(new DataColumnSpecCreator("Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Target Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entry Count", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    ReplaceDictionaryNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("PUT");
        builder.setPath("/v3/glossaries/{glossary_id}/dictionaries");
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.PATH, "glossary_id", this.glossaryId));
        builder.setBodyType(HttpRequestNodeParameters.BodyType.FORM);
        if (this.sourceLangEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "source_lang", this.sourceLang));
        }
        if (this.targetLangEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "target_lang", this.targetLang));
        }
        if (this.entriesEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "entries", this.entries));
        }
        if (this.entriesFormatEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "entries_format", this.entriesFormat));
        }
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class EntriesEnabledRef
    implements BooleanReference {
        private EntriesEnabledRef() {
        }
    }

    private static final class EntriesFormatEnabledRef
    implements BooleanReference {
        private EntriesFormatEnabledRef() {
        }
    }

    private static final class Entries_FormatChoicesProvider
    implements StringChoicesProvider {
        private Entries_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ENTRIES_FORMAT_VALUES);
        }
    }

    private static final class ReplaceDictionaryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ReplaceDictionaryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class SourceLangEnabledRef
    implements BooleanReference {
        private SourceLangEnabledRef() {
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class TargetLangEnabledRef
    implements BooleanReference {
        private TargetLangEnabledRef() {
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }
}

