/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.translatedocument;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeModel;
import com.nodepit.nodes.deepl.v2.operation.translatedocument.TranslateDocumentNodeParameters;
import com.nodepit.nodes.deepl.v2.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public final class TranslateDocumentNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Translate Document").icon("../../node.png").shortDescription("Upload and Translate a Document").fullDescription("\t\t\t<p>This call uploads a document and queues it for translation.\nThe call returns once the upload is complete, returning a document ID and key which can be used to\n<a href=\"https://www.deepl.com/docs-api/documents/get-document-status\">query the translation status</a>\nand to <a href=\"https://www.deepl.com/docs-api/documents/download-document\">download the translated document</a> once translation is complete.</p>\n<p>Because the request includes a file upload, it must be an HTTP POST request with content type <tt>multipart/form-data</tt>.</p>\n<p>Please be aware that the uploaded document is automatically removed from the server once the translated document has been downloaded.\nYou have to upload the document again in order to restart the translation.</p>\n<p>The maximum upload limit for documents is <a href=\"https://support.deepl.com/hc/articles/360020582359-Document-formats\">available here</a>\nand may vary based on API plan and document type.</p>\n<p>You may specify the glossary to use for the document translation using the <tt>glossary_id</tt> parameter.\n<b>Important:</b> This requires the <tt>source_lang</tt> parameter to be set and the language pair of the glossary has to match the language pair of the request.</p>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(TranslateDocumentNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel::execute)).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"translateDocument", "POST /v2/document"});

    public TranslateDocumentNodeFactory() {
        super(NODE);
    }
}

