/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.translatedocument;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class TranslateDocumentNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Source Language", description="Enable to set the optional field <b>Source Language</b>")
    @ValueReference(value=SourceLangEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sourceLangEnabled = false;
    @Widget(title="Source Language", description="\t<p>Language of the text to be translated. Options currently available:</p>\n<ul>\n<li><tt>AR</tt> - Arabic</li>\n<li><tt>BG</tt> - Bulgarian</li>\n<li><tt>CS</tt> - Czech</li>\n<li><tt>DA</tt> - Danish</li>\n<li><tt>DE</tt> - German</li>\n<li><tt>EL</tt> - Greek</li>\n<li><tt>EN</tt> - English</li>\n<li><tt>ES</tt> - Spanish</li>\n<li><tt>ET</tt> - Estonian</li>\n<li><tt>FI</tt> - Finnish</li>\n<li><tt>FR</tt> - French</li>\n<li><tt>HU</tt> - Hungarian</li>\n<li><tt>ID</tt> - Indonesian</li>\n<li><tt>IT</tt> - Italian</li>\n<li><tt>JA</tt> - Japanese</li>\n<li><tt>KO</tt> - Korean</li>\n<li><tt>LT</tt> - Lithuanian</li>\n<li><tt>LV</tt> - Latvian</li>\n<li><tt>NB</tt> - Norwegian (Bokm\u00e5l)</li>\n<li><tt>NL</tt> - Dutch</li>\n<li><tt>PL</tt> - Polish</li>\n<li><tt>PT</tt> - Portuguese (all Portuguese varieties mixed)</li>\n<li><tt>RO</tt> - Romanian</li>\n<li><tt>RU</tt> - Russian</li>\n<li><tt>SK</tt> - Slovak</li>\n<li><tt>SL</tt> - Slovenian</li>\n<li><tt>SV</tt> - Swedish</li>\n<li><tt>TR</tt> - Turkish</li>\n<li><tt>UK</tt> - Ukrainian</li>\n<li><tt>ZH</tt> - Chinese</li>\n</ul>\n<p>If this parameter is omitted, the API will attempt to detect the language of the text and translate it.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SourceLangEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"AR", "BG", "CS", "DA", "DE", "EL", "EN", "ES", "ET", "FI", "FR", "HU", "ID", "IT", "JA", "KO", "LT", "LV", "NB", "NL", "PL", "PT", "RO", "RU", "SK", "SL", "SV", "TR", "UK", "ZH"};
    @Widget(title="Target Language", description="\t<p>The language into which the text should be translated. Options currently available:</p>\n<ul>\n<li><tt>AR</tt> - Arabic</li>\n<li><tt>BG</tt> - Bulgarian</li>\n<li><tt>CS</tt> - Czech</li>\n<li><tt>DA</tt> - Danish</li>\n<li><tt>DE</tt> - German</li>\n<li><tt>EL</tt> - Greek</li>\n<li><tt>EN</tt> - English (unspecified variant for backward compatibility; please select <tt>EN-GB</tt> or <tt>EN-US</tt> instead)</li>\n<li><tt>EN-GB</tt> - English (British)</li>\n<li><tt>EN-US</tt> - English (American)</li>\n<li><tt>ES</tt> - Spanish</li>\n<li><tt>ES-419</tt> - Spanish (Latin American)</li>\n<li><tt>ET</tt> - Estonian</li>\n<li><tt>FI</tt> - Finnish</li>\n<li><tt>FR</tt> - French</li>\n<li><tt>HU</tt> - Hungarian</li>\n<li><tt>ID</tt> - Indonesian</li>\n<li><tt>IT</tt> - Italian</li>\n<li><tt>JA</tt> - Japanese</li>\n<li><tt>KO</tt> - Korean</li>\n<li><tt>LT</tt> - Lithuanian</li>\n<li><tt>LV</tt> - Latvian</li>\n<li><tt>NB</tt> - Norwegian (Bokm\u00e5l)</li>\n<li><tt>NL</tt> - Dutch</li>\n<li><tt>PL</tt> - Polish</li>\n<li><tt>PT</tt> - Portuguese (unspecified variant for backward compatibility; please select <tt>PT-BR</tt> or <tt>PT-PT</tt> instead)</li>\n<li><tt>PT-BR</tt> - Portuguese (Brazilian)</li>\n<li><tt>PT-PT</tt> - Portuguese (all Portuguese varieties excluding Brazilian Portuguese)</li>\n<li><tt>RO</tt> - Romanian</li>\n<li><tt>RU</tt> - Russian</li>\n<li><tt>SK</tt> - Slovak</li>\n<li><tt>SL</tt> - Slovenian</li>\n<li><tt>SV</tt> - Swedish</li>\n<li><tt>TR</tt> - Turkish</li>\n<li><tt>UK</tt> - Ukrainian</li>\n<li><tt>ZH</tt> - Chinese (unspecified variant for backward compatibility; please select <tt>ZH-HANS</tt> instead)</li>\n<li><tt>ZH-HANS</tt> - Chinese (simplified)</li>\n<li><tt>ZH-HANT</tt> - Chinese (traditional)</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"AR", "BG", "CS", "DA", "DE", "EL", "EN-GB", "EN-US", "ES", "ES-419", "ET", "FI", "FR", "HU", "ID", "IT", "JA", "KO", "LT", "LV", "NB", "NL", "PL", "PT-BR", "PT-PT", "RO", "RU", "SK", "SL", "SV", "TR", "UK", "ZH", "ZH-HANS", "ZH-HANT"};
    @Widget(title="File", description="\t<p>The document file to be translated. The file name should be included in this part's content disposition. As an alternative, the filename parameter can be used. The following file types and extensions are supported:</p>\n<ul>\n<li><tt>docx</tt> - Microsoft Word Document</li>\n<li><tt>pptx</tt> - Microsoft PowerPoint Document</li>\n<li><tt>xlsx</tt> - Microsoft Excel Document</li>\n<li><tt>pdf</tt> - Portable Document Format</li>\n<li><tt>htm / html</tt> - HTML Document</li>\n<li><tt>txt</tt> - Plain Text Document</li>\n<li><tt>xlf / xliff</tt> - XLIFF Document, version 2.1</li>\n<li><tt>srt</tt> - SRT Document</li>\n<li><tt>jpeg / jpg / png</tt> - Image</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Set Filename", description="Enable to set the optional field <b>Filename</b>")
    @ValueReference(value=FilenameEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filenameEnabled = false;
    @Widget(title="Filename", description="The name of the uploaded file. Can be used as an alternative to including the file name in the file part's content disposition.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilenameEnabledRef.class, type=Effect.EffectType.SHOW)
    String filename = null;
    @Widget(title="Set Output Format", description="Enable to set the optional field <b>Output Format</b>")
    @ValueReference(value=OutputFormatEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean outputFormatEnabled = false;
    @Widget(title="Output Format", description="\t<p>File extension of desired format of translated file, for example: <tt>docx</tt>. If unspecified, by default the translated file will be in the same format as the input file.</p>\n<p>Note: Not all combinations of input file and translation file extensions are permitted. See <a href=\"https://www.deepl.com/docs-api/documents/format-conversions\">Document Format Conversions</a> for the permitted combinations.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OutputFormatEnabledRef.class, type=Effect.EffectType.SHOW)
    String outputFormat = null;
    @Widget(title="Set Formality", description="Enable to set the optional field <b>Formality</b>")
    @ValueReference(value=FormalityEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean formalityEnabled = false;
    @Widget(title="Formality", description="\t<p>Sets whether the translated text should lean towards formal or informal language.\nThis feature currently only works for target languages\n<tt>DE</tt> (German),\n<tt>FR</tt> (French),\n<tt>IT</tt> (Italian),\n<tt>ES</tt> (Spanish),\n<tt>ES-419</tt> (Latin American Spanish),\n<tt>NL</tt> (Dutch),\n<tt>PL</tt> (Polish),\n<tt>PT-BR</tt> and <tt>PT-PT</tt> (Portuguese),\n<tt>JA</tt> (Japanese),\nand <tt>RU</tt> (Russian).\nLearn more about the plain/polite feature for Japanese <a href=\"https://support.deepl.com/hc/en-us/articles/6306700061852-About-the-plain-polite-feature-in-Japanese\">here</a>.\nSetting this parameter with a target language that does not support formality will fail,\nunless one of the <tt>prefer_...</tt> options are used.\nPossible options are:</p>\n<ul>\n<li><tt>default</tt> (default)</li>\n<li><tt>more</tt> - for a more formal language</li>\n<li><tt>less</tt> - for a more informal language</li>\n<li><tt>prefer_more</tt> - for a more formal language if available, otherwise fallback to default formality</li>\n<li><tt>prefer_less</tt> - for a more informal language if available, otherwise fallback to default formality</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FormalityEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=FormalityChoicesProvider.class)
    String formality = "default";
    private static final String[] FORMALITY_VALUES = new String[]{"default", "more", "less", "prefer_more", "prefer_less"};
    @Widget(title="Set Glossary ID", description="Enable to set the optional field <b>Glossary ID</b>")
    @ValueReference(value=GlossaryIdEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean glossaryIdEnabled = false;
    @Widget(title="Glossary ID", description="A unique ID assigned to a glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GlossaryIdEnabledRef.class, type=Effect.EffectType.SHOW)
    String glossaryId = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Document ID:</b> A unique ID assigned to the uploaded document and the translation process. Must be used when referring to this particular document in subsequent API requests.</li>\n\t<li><b>Document Key:</b> A unique key that is used to encrypt the uploaded document as well as the resulting translation on the server side. Must be provided with every subsequent API request regarding this particular document.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=TranslateDocumentNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"document_id\":\"rows[0][0]\",\"document_key\":\"rows[0][1]\"}}]").addBodyColumn(new DataColumnSpecCreator("Document ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Document Key", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    TranslateDocumentNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.targetLang == null || this.targetLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Language\u201d is required.");
        }
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/v2/document");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        if (this.sourceLangEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "source_lang", this.sourceLang));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "target_lang", this.targetLang));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "file", new HttpRequestNodeParameters.File(this.file)));
        if (this.filenameEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "filename", this.filename));
        }
        if (this.outputFormatEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "output_format", this.outputFormat));
        }
        if (this.formalityEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "formality", this.formality));
        }
        if (this.glossaryIdEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "glossary_id", this.glossaryId));
        }
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class FilenameEnabledRef
    implements BooleanReference {
        private FilenameEnabledRef() {
        }
    }

    private static final class FormalityChoicesProvider
    implements StringChoicesProvider {
        private FormalityChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(FORMALITY_VALUES);
        }
    }

    private static final class FormalityEnabledRef
    implements BooleanReference {
        private FormalityEnabledRef() {
        }
    }

    private static final class GlossaryIdEnabledRef
    implements BooleanReference {
        private GlossaryIdEnabledRef() {
        }
    }

    private static final class OutputFormatEnabledRef
    implements BooleanReference {
        private OutputFormatEnabledRef() {
        }
    }

    private static final class SourceLangEnabledRef
    implements BooleanReference {
        private SourceLangEnabledRef() {
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }

    private static final class TranslateDocumentNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private TranslateDocumentNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

