/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.translatetext;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class TranslateTextNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Text", description="Text to be translated. Only UTF-8-encoded plain text is supported. The parameter may be specified multiple times and translations are returned in the same order as they are requested. Each of the parameter values may contain multiple sentences.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=TextPersistor.class)
    Text[] text = new Text[]{new Text(null)};
    @Widget(title="Set Source Language", description="Enable to set the optional field <b>Source Language</b>")
    @ValueReference(value=SourceLangEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sourceLangEnabled = false;
    @Widget(title="Source Language", description="\t<p>Language of the text to be translated. Options currently available:</p>\n<ul>\n<li><tt>AR</tt> - Arabic</li>\n<li><tt>BG</tt> - Bulgarian</li>\n<li><tt>CS</tt> - Czech</li>\n<li><tt>DA</tt> - Danish</li>\n<li><tt>DE</tt> - German</li>\n<li><tt>EL</tt> - Greek</li>\n<li><tt>EN</tt> - English</li>\n<li><tt>ES</tt> - Spanish</li>\n<li><tt>ET</tt> - Estonian</li>\n<li><tt>FI</tt> - Finnish</li>\n<li><tt>FR</tt> - French</li>\n<li><tt>HE</tt> - Hebrew</li>\n<li><tt>HU</tt> - Hungarian</li>\n<li><tt>ID</tt> - Indonesian</li>\n<li><tt>IT</tt> - Italian</li>\n<li><tt>JA</tt> - Japanese</li>\n<li><tt>KO</tt> - Korean</li>\n<li><tt>LT</tt> - Lithuanian</li>\n<li><tt>LV</tt> - Latvian</li>\n<li><tt>NB</tt> - Norwegian (Bokm\u00e5l)</li>\n<li><tt>NL</tt> - Dutch</li>\n<li><tt>PL</tt> - Polish</li>\n<li><tt>PT</tt> - Portuguese (all Portuguese varieties mixed)</li>\n<li><tt>RO</tt> - Romanian</li>\n<li><tt>RU</tt> - Russian</li>\n<li><tt>SK</tt> - Slovak</li>\n<li><tt>SL</tt> - Slovenian</li>\n<li><tt>SV</tt> - Swedish</li>\n<li><tt>TH</tt> - Thai</li>\n<li><tt>TR</tt> - Turkish</li>\n<li><tt>UK</tt> - Ukrainian</li>\n<li><tt>VI</tt> - Vietnamese</li>\n<li><tt>ZH</tt> - Chinese</li>\n</ul>\n<p>If this parameter is omitted, the API will attempt to detect the language of the text and translate it.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SourceLangEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"AR", "BG", "CS", "DA", "DE", "EL", "EN", "ES", "ET", "FI", "FR", "HE", "HU", "ID", "IT", "JA", "KO", "LT", "LV", "NB", "NL", "PL", "PT", "RO", "RU", "SK", "SL", "SV", "TH", "TR", "UK", "VI", "ZH"};
    @Widget(title="Target Language", description="\t<p>The language into which the text should be translated. Options currently available:</p>\n<ul>\n<li><tt>AR</tt> - Arabic</li>\n<li><tt>BG</tt> - Bulgarian</li>\n<li><tt>CS</tt> - Czech</li>\n<li><tt>DA</tt> - Danish</li>\n<li><tt>DE</tt> - German</li>\n<li><tt>EL</tt> - Greek</li>\n<li><tt>EN</tt> - English (unspecified variant for backward compatibility; please select <tt>EN-GB</tt> or <tt>EN-US</tt> instead)</li>\n<li><tt>EN-GB</tt> - English (British)</li>\n<li><tt>EN-US</tt> - English (American)</li>\n<li><tt>ES</tt> - Spanish</li>\n<li><tt>ES-419</tt> - Spanish (Latin American)</li>\n<li><tt>ET</tt> - Estonian</li>\n<li><tt>FI</tt> - Finnish</li>\n<li><tt>FR</tt> - French</li>\n<li><tt>HE</tt> - Hebrew</li>\n<li><tt>HU</tt> - Hungarian</li>\n<li><tt>ID</tt> - Indonesian</li>\n<li><tt>IT</tt> - Italian</li>\n<li><tt>JA</tt> - Japanese</li>\n<li><tt>KO</tt> - Korean</li>\n<li><tt>LT</tt> - Lithuanian</li>\n<li><tt>LV</tt> - Latvian</li>\n<li><tt>NB</tt> - Norwegian (Bokm\u00e5l)</li>\n<li><tt>NL</tt> - Dutch</li>\n<li><tt>PL</tt> - Polish</li>\n<li><tt>PT</tt> - Portuguese (unspecified variant for backward compatibility; please select <tt>PT-BR</tt> or <tt>PT-PT</tt> instead)</li>\n<li><tt>PT-BR</tt> - Portuguese (Brazilian)</li>\n<li><tt>PT-PT</tt> - Portuguese (all Portuguese variants excluding Brazilian Portuguese)</li>\n<li><tt>RO</tt> - Romanian</li>\n<li><tt>RU</tt> - Russian</li>\n<li><tt>SK</tt> - Slovak</li>\n<li><tt>SL</tt> - Slovenian</li>\n<li><tt>SV</tt> - Swedish</li>\n<li><tt>TH</tt> - Thai</li>\n<li><tt>TR</tt> - Turkish</li>\n<li><tt>UK</tt> - Ukrainian</li>\n<li><tt>VI</tt> - Vietnamese</li>\n<li><tt>ZH</tt> - Chinese (unspecified variant for backward compatibility; please select <tt>ZH-HANS</tt> or <tt>ZH-HANT</tt> instead)</li>\n<li><tt>ZH-HANS</tt> - Chinese (simplified)</li>\n<li><tt>ZH-HANT</tt> - Chinese (traditional)</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"AR", "BG", "CS", "DA", "DE", "EL", "EN-GB", "EN-US", "ES", "ES-419", "ET", "FI", "FR", "HE", "HU", "ID", "IT", "JA", "KO", "LT", "LV", "NB", "NL", "PL", "PT-BR", "PT-PT", "RO", "RU", "SK", "SL", "SV", "TH", "TR", "UK", "VI", "ZH", "ZH-HANS", "ZH-HANT"};
    @Widget(title="Set Context", description="Enable to set the optional field <b>Context</b>")
    @ValueReference(value=ContextEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean contextEnabled = false;
    @Widget(title="Context", description="\t<p>The <tt>context</tt> parameter makes it possible to include additional context that can influence a translation but is not translated itself.\nThis additional context can potentially improve translation quality when translating short, low-context source texts such\nas product names on an e-commerce website, article headlines on a news website, or UI elements.</p>\n<p>For example...</p>\n<ul>\n<li>When translating a product name, you might pass the product description as context.</li>\n<li>When translating a news article headline, you might pass the first few sentences or a summary of the article as context.</li>\n</ul>\n<p>For best results, we recommend sending a few complete sentences of context in the same language as the source text.\nThere is no size limit for the <tt>context</tt> parameter itself, but the request body size limit of 128 KiB still applies to\nall text translation requests.</p>\n<p>If you send a request with multiple <tt>text</tt> parameters, the <tt>context</tt> parameter will be applied to each one.</p>\n<p>Characters included in the <tt>context</tt> parameter will not be counted toward billing (i.e. there is no additional\ncost for using the <tt>context</tt> parameter, and only characters sent in the text parameter(s) will be counted toward\nbilling for text translation even when the <tt>context</tt> parameter is included in a request).</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ContextEnabledRef.class, type=Effect.EffectType.SHOW)
    String context = null;
    @Widget(title="Set Show Billed Characters", description="Enable to set the optional field <b>Show Billed Characters</b>")
    @ValueReference(value=ShowBilledCharactersEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean showBilledCharactersEnabled = false;
    @Widget(title="Show Billed Characters", description="\t<p>When true, the response will include the billed_characters parameter, giving the\nnumber of characters from the request that will be counted by DeepL for billing purposes.</p>\n<p>Note: for requests sent as URL-encoded forms, boolean values should be specified as &quot;1&quot; or &quot;0&quot;.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ShowBilledCharactersEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Show_Billed_CharactersPersistor.class)
    String showBilledCharacters = "false";
    @Widget(title="Set Split Sentences", description="Enable to set the optional field <b>Split Sentences</b>")
    @ValueReference(value=SplitSentencesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean splitSentencesEnabled = false;
    @Widget(title="Split Sentences", description="\t<p>Sets whether the translation engine should first split the input into sentences. For text translations where\n<tt>tag_handling</tt> is not set to <tt>html</tt>, the default value is <tt>1</tt>, meaning the engine splits on punctuation and on newlines.</p>\n<p>For text translations where <tt>tag_handling=html</tt>, the default value is <tt>nonewlines</tt>, meaning the engine splits on punctuation only, ignoring newlines.</p>\n<p>The use of <tt>nonewlines</tt> as the default value for text translations where <tt>tag_handling=html</tt> is new behavior that was implemented in November 2022,\nwhen HTML handling was moved out of beta.</p>\n<p>Possible values are:</p>\n<ul>\n<li><tt>0</tt> - no splitting at all, whole input is treated as one sentence</li>\n<li><tt>1</tt> (default when <tt>tag_handling</tt> is not set to <tt>html</tt>) - splits on punctuation and on newlines</li>\n<li><tt>nonewlines</tt> (default when <tt>tag_handling=html</tt>) - splits on punctuation only, ignoring newlines</li>\n</ul>\n<p>For applications that send one sentence per text parameter, we recommend setting <tt>split_sentences</tt> to <tt>0</tt>, in order to prevent the engine from splitting the sentence unintentionally.</p>\n<p>Please note that newlines will split sentences when <tt>split_sentences=1</tt>. We recommend cleaning files so they don't contain breaking sentences or setting the parameter <tt>split_sentences</tt> to <tt>nonewlines</tt>.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SplitSentencesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Split_SentencesChoicesProvider.class)
    String splitSentences = "1";
    private static final String[] SPLIT_SENTENCES_VALUES = new String[]{"0", "1", "nonewlines"};
    @Widget(title="Set Preserve Formatting", description="Enable to set the optional field <b>Preserve Formatting</b>")
    @ValueReference(value=PreserveFormattingEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean preserveFormattingEnabled = false;
    @Widget(title="Preserve Formatting", description="\t<p>Sets whether the translation engine should respect the original formatting, even if it would usually correct some aspects. Possible values are:</p>\n<ul>\n<li><tt>0</tt> (default)</li>\n<li><tt>1</tt></li>\n</ul>\n<p>The formatting aspects affected by this setting include:</p>\n<ul>\n<li>Punctuation at the beginning and end of the sentence</li>\n<li>Upper/lower case at the beginning of the sentence</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PreserveFormattingEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Preserve_FormattingChoicesProvider.class)
    String preserveFormatting = "0";
    private static final String[] PRESERVE_FORMATTING_VALUES = new String[]{"0", "1"};
    @Widget(title="Set Formality", description="Enable to set the optional field <b>Formality</b>")
    @ValueReference(value=FormalityEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean formalityEnabled = false;
    @Widget(title="Formality", description="\t<p>Sets whether the translated text should lean towards formal or informal language.\nThis feature currently only works for target languages\n<tt>DE</tt> (German),\n<tt>FR</tt> (French),\n<tt>IT</tt> (Italian),\n<tt>ES</tt> (Spanish),\n<tt>ES-419</tt> (Latin American Spanish),\n<tt>NL</tt> (Dutch),\n<tt>PL</tt> (Polish),\n<tt>PT-BR</tt> and <tt>PT-PT</tt> (Portuguese),\n<tt>JA</tt> (Japanese),\nand <tt>RU</tt> (Russian).\nLearn more about the plain/polite feature for Japanese <a href=\"https://support.deepl.com/hc/en-us/articles/6306700061852-About-the-plain-polite-feature-in-Japanese\">here</a>.\nSetting this parameter with a target language that does not support formality will fail,\nunless one of the <tt>prefer_...</tt> options are used.\nPossible options are:</p>\n<ul>\n<li><tt>default</tt> (default)</li>\n<li><tt>more</tt> - for a more formal language</li>\n<li><tt>less</tt> - for a more informal language</li>\n<li><tt>prefer_more</tt> - for a more formal language if available, otherwise fallback to default formality</li>\n<li><tt>prefer_less</tt> - for a more informal language if available, otherwise fallback to default formality</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FormalityEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=FormalityChoicesProvider.class)
    String formality = "default";
    private static final String[] FORMALITY_VALUES = new String[]{"default", "more", "less", "prefer_more", "prefer_less"};
    @Widget(title="Set Model Type", description="Enable to set the optional field <b>Model Type</b>")
    @ValueReference(value=ModelTypeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean modelTypeEnabled = false;
    @Widget(title="Model Type", description="\t<p>Specifies which DeepL model should be used for translation.</p>\n<p>Possible values are:</p>\n<ul>\n<li><tt>latency_optimized</tt> (default) - uses lower latency \u201cclassic\u201d translation models, which support all language pairs;\ndefault value</li>\n<li><tt>quality_optimized</tt> - uses higher latency, improved quality \u201cnext-gen\u201d translation models, which support only a\nsubset of language pairs; if a language pair that is not supported by next-gen models is included in the\nrequest, it will fail. Consider using prefer_quality_optimized instead.</li>\n<li><tt>prefer_quality_optimized</tt> - prioritizes use of higher latency, improved quality \u201cnext-gen\u201d translation models,\nwhich support only a subset of DeepL languages; if a request includes a language pair not supported by\nnext-gen models, the request will fall back to latency_optimized classic models.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ModelTypeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Model_TypeChoicesProvider.class)
    String modelType = MODEL_TYPE_VALUES[0];
    private static final String[] MODEL_TYPE_VALUES = new String[]{"quality_optimized", "prefer_quality_optimized", "latency_optimized"};
    @Widget(title="Set Glossary ID", description="Enable to set the optional field <b>Glossary ID</b>")
    @ValueReference(value=GlossaryIdEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean glossaryIdEnabled = false;
    @Widget(title="Glossary ID", description="Specify the glossary to use for the translation. <b>Important:</b> This requires the <tt>source_lang</tt> parameter to be set and the language pair of the glossary has to match the language pair of the request.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GlossaryIdEnabledRef.class, type=Effect.EffectType.SHOW)
    String glossaryId = null;
    @Widget(title="Set Tag Handling", description="Enable to set the optional field <b>Tag Handling</b>")
    @ValueReference(value=TagHandlingEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean tagHandlingEnabled = false;
    @Widget(title="Tag Handling", description="\t<p>Sets which kind of tags should be handled. Options currently available:</p>\n<ul>\n<li><tt>xml</tt>: Enable XML tag handling; see <a href=\"https://www.deepl.com/docs-api/xml\">XML Handling</a>.</li>\n<li><tt>html</tt>: Enable HTML tag handling; see <a href=\"https://www.deepl.com/docs-api/html\">HTML Handling</a>.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TagHandlingEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Tag_HandlingChoicesProvider.class)
    String tagHandling = TAG_HANDLING_VALUES[0];
    private static final String[] TAG_HANDLING_VALUES = new String[]{"xml", "html"};
    @Widget(title="Set Tag Handling Version", description="Enable to set the optional field <b>Tag Handling Version</b>")
    @ValueReference(value=TagHandlingVersionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean tagHandlingVersionEnabled = false;
    @Widget(title="Tag Handling Version", description="\t<p>Sets which version of the tag handling algorithm should be used. Options currently available:</p>\n<ul>\n<li><tt>v2</tt>: Improved algorithm released in October 2025 (default as of December 2025).</li>\n<li><tt>v1</tt>: Traditional algorithm (default until December 2025).</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TagHandlingVersionEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Tag_Handling_VersionChoicesProvider.class)
    String tagHandlingVersion = TAG_HANDLING_VERSION_VALUES[0];
    private static final String[] TAG_HANDLING_VERSION_VALUES = new String[]{"v1", "v2"};
    @Widget(title="Set Outline Detection", description="Enable to set the optional field <b>Outline Detection</b>")
    @ValueReference(value=OutlineDetectionEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean outlineDetectionEnabled = false;
    @Widget(title="Outline Detection", description="\t<p>The automatic detection of the XML structure won't yield best results in all XML files. You can disable this automatic mechanism altogether by setting the <tt>outline_detection</tt> parameter to <tt>0</tt> and selecting the tags that should be considered structure tags. This will split sentences using the <tt>splitting_tags</tt> parameter.</p>\n<p>In the example below, we achieve the same results as the automatic engine by disabling automatic detection with <tt>outline_detection=0</tt> and setting the parameters manually to <tt>tag_handling=xml</tt>, <tt>split_sentences=nonewlines</tt>,  and <tt>splitting_tags=par,title</tt>.</p>\n<ul>\n<li>Example request:\n<pre>&lt;document&gt;\n  &lt;meta&gt;\n    &lt;title&gt;A document's title&lt;/title&gt;\n  &lt;/meta&gt;\n  &lt;content&gt;\n    &lt;par&gt;This is the first sentence. Followed by a second one.&lt;/par&gt;\n    &lt;par&gt;This is the third sentence.&lt;/par&gt;\n  &lt;/content&gt;\n&lt;/document&gt;\n</pre>\n</li>\n<li>Example response:\n<pre>&lt;document&gt;\n  &lt;meta&gt;\n    &lt;title&gt;Der Titel eines Dokuments&lt;/title&gt;\n  &lt;/meta&gt;\n  &lt;content&gt;\n    &lt;par&gt;Das ist der erste Satz. Gefolgt von einem zweiten.&lt;/par&gt;\n    &lt;par&gt;Dies ist der dritte Satz.&lt;/par&gt;\n  &lt;/content&gt;\n&lt;/document&gt;\n</pre>\n</li>\n</ul>\n<p>While this approach is slightly more complicated, it allows for greater control over the structure of the translation output.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OutlineDetectionEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Outline_DetectionChoicesProvider.class)
    String outlineDetection = OUTLINE_DETECTION_VALUES[0];
    private static final String[] OUTLINE_DETECTION_VALUES = new String[]{"0"};
    @Widget(title="Set Non Splitting Tags", description="Enable to set the optional field <b>Non Splitting Tags</b>")
    @ValueReference(value=NonSplittingTagsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nonSplittingTagsEnabled = false;
    @Widget(title="Non Splitting Tags", description="\t<p>Comma-separated list of XML tags which never split sentences.</p>\n<p>For some XML files, finding tags with textual content and splitting sentences using those tags won't yield the best results. The following example shows the engine splitting sentences on <tt>par</tt> tags and proceeding to translate the parts separately, resulting in an incorrect translation:</p>\n<ul>\n<li>Example request:</li>\n</ul>\n<pre>&lt;par&gt;The firm said it had been &lt;/par&gt;&lt;par&gt; conducting an internal investigation.&lt;/par&gt;\n</pre>\n<ul>\n<li>Example response:</li>\n</ul>\n<pre>&lt;par&gt;Die Firma sagte, es sei eine gute Idee gewesen.&lt;/par&gt;&lt;par&gt; Durchf\u00fchrung einer internen Untersuchung.&lt;/par&gt;\n</pre>\n<p>As this can lead to bad translations, this type of structure should either be avoided, or the <tt>non_splitting_tags</tt> parameter should be set. The following example shows the same call, with the parameter set to <tt>par</tt>:</p>\n<ul>\n<li>Example request:</li>\n</ul>\n<pre>&lt;par&gt;The firm said it had been &lt;/par&gt;&lt;par&gt; conducting an internal investigation.&lt;/par&gt;\n</pre>\n<ul>\n<li>Example response:</li>\n</ul>\n<pre>&lt;par&gt;Die Firma sagte, dass sie&lt;/par&gt;&lt;par&gt; eine interne Untersuchung durchgef\u00fchrt&lt;/par&gt;&lt;par&gt; habe&lt;/par&gt;&lt;par&gt;.&lt;/par&gt;\n</pre>\n<p>This time, the sentence is translated as a whole. The XML tags are now considered markup and copied into the translated sentence. As the translation of the words &quot;had been&quot; has moved to another position in the German sentence, the two par tags are duplicated (which is expected here).</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NonSplittingTagsEnabledRef.class, type=Effect.EffectType.SHOW)
    String nonSplittingTags = null;
    @Widget(title="Set Splitting Tags", description="Enable to set the optional field <b>Splitting Tags</b>")
    @ValueReference(value=SplittingTagsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean splittingTagsEnabled = false;
    @Widget(title="Splitting Tags", description="\t<p>Comma-separated list of XML tags which always cause splits.</p>\n<p>See the example in the <tt>outline_detection</tt> parameter's description.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SplittingTagsEnabledRef.class, type=Effect.EffectType.SHOW)
    String splittingTags = null;
    @Widget(title="Set Ignore Tags", description="Enable to set the optional field <b>Ignore Tags</b>")
    @ValueReference(value=IgnoreTagsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean ignoreTagsEnabled = false;
    @Widget(title="Ignore Tags", description="\t<p>Comma-separated list of XML tags that indicate text not to be translated.</p>\n<p>Use this parameter to ensure that elements in the original text are not altered in the translation (e.g., trademarks, product names) and insert tags into your original text. In the following example, the <tt>ignore_tags</tt> parameter is set to <tt>keep</tt>:</p>\n<ul>\n<li>Example request:\n<pre>Please open the page &lt;keep&gt;Settings&lt;/keep&gt; to configure your system.\n</pre>\n</li>\n<li>Example response:\n<pre>Bitte \u00f6ffnen Sie die Seite &lt;keep&gt;Settings&lt;/keep&gt; um Ihr System zu konfigurieren.\n</pre>\n</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IgnoreTagsEnabledRef.class, type=Effect.EffectType.SHOW)
    String ignoreTags = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Detected Source Language:</b> The language detected in the source text. It reflects the value of the <tt>source_lang</tt> parameter, when specified.</li>\n\t<li><b>Text:</b> The translated text.</li>\n\t<li><b>Billed Characters:</b> Number of characters counted by DeepL for billing purposes. Only present if the show_billed_characters parameter is set to true.</li>\n\t<li><b>Model Type Used:</b> Indicates the translation model used. Only present if model_type parameter is included in the request.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n\t<li><b>X-Trace-ID:</b> A unique identifier for the request that can be included in bug reports to DeepL support.</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=TranslateTextNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"translations\":{\"*\":{\"detected_source_language\":\"rows[#2][0]\",\"text\":\"rows[#2][1]\",\"billed_characters\":\"rows[#2][2]\",\"model_type_used\":\"rows[#2][3]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Detected Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Billed Characters", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Model Type Used", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().addHeaderColumn(new DataColumnSpecCreator("X-Trace-ID", StringCell.StringCellFactory.TYPE).createSpec()).build()};

    TranslateTextNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.text == null || this.text.length == 0) {
            throw new InvalidSettingsException("Value for \u201cText\u201d is required.");
        }
        if (this.targetLang == null || this.targetLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Language\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/v2/translate");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.FORM);
        Arrays.stream(this.text).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "text", value.text)));
        if (this.sourceLangEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "source_lang", this.sourceLang));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "target_lang", this.targetLang));
        if (this.contextEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "context", this.context));
        }
        if (this.showBilledCharactersEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "show_billed_characters", this.showBilledCharacters));
        }
        if (this.splitSentencesEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "split_sentences", this.splitSentences));
        }
        if (this.preserveFormattingEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "preserve_formatting", this.preserveFormatting));
        }
        if (this.formalityEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "formality", this.formality));
        }
        if (this.modelTypeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "model_type", this.modelType));
        }
        if (this.glossaryIdEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "glossary_id", this.glossaryId));
        }
        if (this.tagHandlingEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "tag_handling", this.tagHandling));
        }
        if (this.tagHandlingVersionEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "tag_handling_version", this.tagHandlingVersion));
        }
        if (this.outlineDetectionEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "outline_detection", this.outlineDetection));
        }
        if (this.nonSplittingTagsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "non_splitting_tags", this.nonSplittingTags));
        }
        if (this.splittingTagsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "splitting_tags", this.splittingTags));
        }
        if (this.ignoreTagsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "ignore_tags", this.ignoreTags));
        }
        builder.setResponseType("application/json");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ContextEnabledRef
    implements BooleanReference {
        private ContextEnabledRef() {
        }
    }

    private static final class FormalityChoicesProvider
    implements StringChoicesProvider {
        private FormalityChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(FORMALITY_VALUES);
        }
    }

    private static final class FormalityEnabledRef
    implements BooleanReference {
        private FormalityEnabledRef() {
        }
    }

    private static final class GlossaryIdEnabledRef
    implements BooleanReference {
        private GlossaryIdEnabledRef() {
        }
    }

    private static final class IgnoreTagsEnabledRef
    implements BooleanReference {
        private IgnoreTagsEnabledRef() {
        }
    }

    private static final class ModelTypeEnabledRef
    implements BooleanReference {
        private ModelTypeEnabledRef() {
        }
    }

    private static final class Model_TypeChoicesProvider
    implements StringChoicesProvider {
        private Model_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(MODEL_TYPE_VALUES);
        }
    }

    private static final class NonSplittingTagsEnabledRef
    implements BooleanReference {
        private NonSplittingTagsEnabledRef() {
        }
    }

    private static final class OutlineDetectionEnabledRef
    implements BooleanReference {
        private OutlineDetectionEnabledRef() {
        }
    }

    private static final class Outline_DetectionChoicesProvider
    implements StringChoicesProvider {
        private Outline_DetectionChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OUTLINE_DETECTION_VALUES);
        }
    }

    private static final class PreserveFormattingEnabledRef
    implements BooleanReference {
        private PreserveFormattingEnabledRef() {
        }
    }

    private static final class Preserve_FormattingChoicesProvider
    implements StringChoicesProvider {
        private Preserve_FormattingChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(PRESERVE_FORMATTING_VALUES);
        }
    }

    private static final class ShowBilledCharactersEnabledRef
    implements BooleanReference {
        private ShowBilledCharactersEnabledRef() {
        }
    }

    private static final class Show_Billed_CharactersPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "showBilledCharacters";

        private Show_Billed_CharactersPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class SourceLangEnabledRef
    implements BooleanReference {
        private SourceLangEnabledRef() {
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class SplitSentencesEnabledRef
    implements BooleanReference {
        private SplitSentencesEnabledRef() {
        }
    }

    private static final class Split_SentencesChoicesProvider
    implements StringChoicesProvider {
        private Split_SentencesChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SPLIT_SENTENCES_VALUES);
        }
    }

    private static final class SplittingTagsEnabledRef
    implements BooleanReference {
        private SplittingTagsEnabledRef() {
        }
    }

    private static final class TagHandlingEnabledRef
    implements BooleanReference {
        private TagHandlingEnabledRef() {
        }
    }

    private static final class TagHandlingVersionEnabledRef
    implements BooleanReference {
        private TagHandlingVersionEnabledRef() {
        }
    }

    private static final class Tag_HandlingChoicesProvider
    implements StringChoicesProvider {
        private Tag_HandlingChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TAG_HANDLING_VALUES);
        }
    }

    private static final class Tag_Handling_VersionChoicesProvider
    implements StringChoicesProvider {
        private Tag_Handling_VersionChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TAG_HANDLING_VERSION_VALUES);
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }

    static final class Text
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Text() {
        }

        Text(String text) {
            this.text = text;
        }
    }

    private static final class TextPersistor
    implements NodeParametersPersistor<Text[]> {
        static final String CONFIG_KEY = "text";

        private TextPersistor() {
        }

        public Text[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Text[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Text::new).toArray(Text[]::new);
        }

        public void save(Text[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class TranslateTextNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private TranslateTextNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

