/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getglossary;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetGlossaryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Glossary ID:</b> A unique ID assigned to a glossary.</li>\n\t\t<li><b>Name:</b> Name associated with the glossary.</li>\n\t\t<li><b>Ready:</b> Indicates if the newly created glossary can already be used in <tt>translate</tt> requests.\nIf the created glossary is not yet ready, you have to wait and check the <tt>ready</tt> status\nof the glossary before using it in a <tt>translate</tt> request.</li>\n\t\t<li><b>Source Language:</b> The language in which the source texts in the glossary are specified.</li>\n\t\t<li><b>Target Language:</b> The language in which the target texts in the glossary are specified.</li>\n\t\t<li><b>Creation Time:</b> The creation time of the glossary in the ISO 8601-1:2019 format (e.g.: <tt>2021-08-03T14:16:18.329Z</tt>).</li>\n\t\t<li><b>Entry Count:</b> The number of entries in the glossary.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetGlossaryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"glossary_id\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"ready\":\"rows[0][2]\",\"source_lang\":\"rows[0][3]\",\"target_lang\":\"rows[0][4]\",\"creation_time\":\"rows[0][5]\",\"entry_count\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Glossary ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Ready", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Target Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Creation Time", ZonedDateTimeCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entry Count", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetGlossaryNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("glossary_id", this.glossaryId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetGlossaryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetGlossaryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

