/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.migration;

import com.nodepit.nodes.deepl.v2.server.ServerNodeFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeFactory;
import org.knime.core.node.NodeSettingsRO;
import org.knime.workflow.migration.MigrationException;
import org.knime.workflow.migration.MigrationNodeMatchResult;
import org.knime.workflow.migration.NodeMigrationAction;
import org.knime.workflow.migration.NodeMigrationRule;
import org.knime.workflow.migration.NodeSettingsMigrationManager;
import org.knime.workflow.migration.model.MigrationNode;

public class V3ServerMigrationRule
extends NodeMigrationRule {
    protected Class<? extends NodeFactory<?>> getReplacementNodeFactoryClass(MigrationNode migrationNode, MigrationNodeMatchResult matchResult) {
        return ServerNodeFactory.class;
    }

    protected MigrationNodeMatchResult match(MigrationNode migrationNode) {
        if (ServerNodeFactory.class.equals((Object)migrationNode.getOriginalNodeFactoryClass())) {
            try {
                NodeSettingsRO nodeSettings = migrationNode.getOriginalNodeModelSettings();
                String server = nodeSettings.getString("server");
                if (server.endsWith("/v2")) {
                    return MigrationNodeMatchResult.of((MigrationNode)migrationNode, (NodeMigrationAction)NodeMigrationAction.REPLACE);
                }
            }
            catch (InvalidSettingsException | MigrationException throwable) {}
        }
        return MigrationNodeMatchResult.NO_MATCH;
    }

    protected void migrate(MigrationNode migrationNode, MigrationNodeMatchResult matchResult) throws MigrationException {
        this.associateEveryOriginalPortWithNew(migrationNode);
        NodeSettingsMigrationManager settingsManager = this.createSettingsManager(migrationNode);
        settingsManager.copyAllModelAndOptionalVariableSettings(new String[0]).toIdentical();
        settingsManager.copyAllMiscellaneousSettings(new String[0]).toIdentical();
        String server = settingsManager.getSourceModelSettings().getString("server", "https://api.deepl.com").replaceAll("/v2$", "");
        settingsManager.getDestinationModelSettings().addString("server", server);
    }
}

