/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.knime.core.util.FileUtil;

public final class Utils {
    public static String getFilename(String stringValue) {
        return stringValue.substring(stringValue.lastIndexOf(47) + 1);
    }

    public static RequestBody getRequestBody(String stringValue) {
        String contentType;
        File file = Utils.resolveFile(stringValue);
        try {
            contentType = Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return RequestBody.create((File)file, (MediaType)MediaType.parse((String)contentType));
    }

    private static File resolveFile(String filePath) {
        URL url;
        Objects.requireNonNull(filePath, "filePath was null");
        try {
            url = new URL(filePath);
        }
        catch (MalformedURLException malformedURLException) {
            File tmp = new File(filePath);
            if (tmp.isFile() && tmp.canRead()) {
                try {
                    url = tmp.getAbsoluteFile().toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            throw new IllegalArgumentException("File/URL \"" + filePath + "\" cannot be parsed as a URL or represents a non exising file location");
        }
        File resolvedFile = FileUtil.getFileFromURL((URL)url);
        if (resolvedFile == null) {
            throw new IllegalStateException("Could not resolve " + filePath);
        }
        return resolvedFile;
    }

    public static boolean validateJsonBySchema(String json, String schemaFile, Class<?> cls) {
        Objects.requireNonNull(json, "json was null");
        Objects.requireNonNull(schemaFile, "schemaFile was null");
        Objects.requireNonNull(cls, "cls was null");
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream stream = cls.getResourceAsStream(schemaFile);){
                JsonSchemaFactory schemaFactory = JsonSchemaFactory.byDefault();
                JsonNode jsonNode = (JsonNode)new ObjectMapper().readValue(stream, JsonNode.class);
                JsonSchema jsonSchema = schemaFactory.getJsonSchema(jsonNode);
                ProcessingReport report = jsonSchema.validate(Utils.parseJson(json));
                return report.isSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonMappingException jsonMappingException) {
            return false;
        }
        catch (JsonProcessingException jsonProcessingException) {
            return false;
        }
        catch (ProcessingException processingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static JsonNode parseJson(String schema) throws JsonProcessingException, JsonMappingException {
        return (JsonNode)new ObjectMapper().readValue(schema, JsonNode.class);
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format(Locale.ENGLISH, "%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String encodeUrlPathComponent(String pathComponent) {
        Objects.requireNonNull(pathComponent, "name was null");
        try {
            return URLEncoder.encode(pathComponent, "utf8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("utf8 encoding not supported", e);
        }
    }

    public static String readToString(String filename, Class<?> cls) {
        Objects.requireNonNull(filename, "filename was null");
        Objects.requireNonNull(cls, "cls was null");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = cls.getResourceAsStream(filename);){
                return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read " + filename, e);
        }
    }

    public static String wrap(String input, int length) {
        return Utils.wrap(input, length, "");
    }

    public static String wrap(String input, int length, String margin) {
        StringBuilder result = new StringBuilder();
        int lineLength = 0;
        String[] stringArray = input.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (lineLength + word.length() > length - margin.length()) {
                result.append("\n").append(margin);
                lineLength = margin.length();
            } else if (lineLength > 0) {
                result.append(" ");
                ++lineLength;
            } else {
                result.append(margin);
                lineLength += margin.length();
            }
            result.append(word);
            lineLength += word.length();
            ++n2;
        }
        return result.toString();
    }

    private Utils() {
    }
}

