/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.auth.authheader;

import com.nodepit.nodes.deepl.v2.InterceptorFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthHeaderInterceptorFactory
extends InterceptorFactory<ApiKeyAuthData> {
    public static final String IDENTIFIER = "auth_header";
    private static final String API_KEY_PREFIX = "DeepL-Auth-Key";

    public AuthHeaderInterceptorFactory() {
        super(IDENTIFIER, ApiKeyAuthData.class);
    }

    @Override
    protected Interceptor createInterceptor(final ApiKeyAuthData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                Object apikey = data.apiKey;
                if (AuthHeaderInterceptorFactory.API_KEY_PREFIX != null) {
                    apikey = "DeepL-Auth-Key " + (String)apikey;
                }
                Request authRequest = originalRequest.newBuilder().header("Authorization", (String)apikey).build();
                return chain.proceed(authRequest);
            }
        };
    }

    public static final class ApiKeyAuthData {
        String apiKey;
    }
}

