/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.admingetanalytics;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class AdminGetAnalyticsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Start Date", description="Start date for the usage report (ISO 8601 date format).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String startDate = null;
    @Widget(title="End Date", description="End date for the usage report (ISO 8601 date format).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String endDate = null;
    @Widget(title="Set Group By", description="Enable to set the optional field <b>Group By</b>")
    @ValueReference(value=GroupByEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean groupByEnabled = false;
    @Widget(title="Group By", description="\t<p>Optional parameter to group usage statistics. Possible values:</p>\n<ul>\n<li><tt>key</tt> - Group by API key</li>\n<li><tt>key_and_day</tt> - Group by API key and usage date</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GroupByEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Group_ByChoicesProvider.class)
    String groupBy = GROUP_BY_VALUES[0];
    private static final String[] GROUP_BY_VALUES = new String[]{"key", "key_and_day"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=AdminGetAnalyticsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    AdminGetAnalyticsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.startDate == null || this.startDate.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cStart Date\u201d is required.");
        }
        if (this.endDate == null || this.endDate.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cEnd Date\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("start_date", this.startDate));
        params.add(new HttpRequestNodeParameters.Param("end_date", this.endDate));
        if (this.groupByEnabled) {
            params.add(new HttpRequestNodeParameters.Param("group_by", this.groupBy));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AdminGetAnalyticsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private AdminGetAnalyticsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class GroupByEnabledRef
    implements BooleanReference {
        private GroupByEnabledRef() {
        }
    }

    private static final class Group_ByChoicesProvider
    implements StringChoicesProvider {
        private Group_ByChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(GROUP_BY_VALUES);
        }
    }
}

