/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getdocumentstatus;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetDocumentStatusNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Document ID", description="The document ID that was sent to the client when the document was uploaded to the API.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String documentId = null;
    @Widget(title="Document Key", description="The document encryption key that was sent to the client when the document was uploaded to the API.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String documentKey = null;
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Document ID:</b> A unique ID assigned to the uploaded document and the requested translation process. The same ID that was used when requesting the translation status.</li>\n\t\t<li><b>Status:</b> <p>A short description of the state the document translation process is currently in. Possible values are:</p>\n<ul>\n<li><tt>queued</tt> - the translation job is waiting in line to be processed</li>\n<li><tt>translating</tt> - the translation is currently ongoing</li>\n<li><tt>done</tt> - the translation is done and the translated document is ready for download</li>\n<li><tt>error</tt> - an irrecoverable error occurred while translating the document</li>\n</ul></li>\n\t\t<li><b>Seconds Remaining:</b> Estimated number of seconds until the translation is done.\nThis parameter is only included while <tt>status</tt> is <tt>&quot;translating&quot;</tt>.</li>\n\t\t<li><b>Billed Characters:</b> The number of characters billed to your account. The characters will only be billed after a successful download request.</li>\n\t\t<li><b>Error Message:</b> A short description of the error, if available.\nNote that the content is subject to change.\nThis parameter may be included if an error occurred during translation.</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetDocumentStatusNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"document_id\":\"rows[0][0]\",\"status\":\"rows[0][1]\",\"seconds_remaining\":\"rows[0][2]\",\"billed_characters\":\"rows[0][3]\",\"error_message\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("Document ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Status", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Seconds Remaining", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Billed Characters", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Error Message", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetDocumentStatusNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.documentId == null || this.documentId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDocument ID\u201d is required.");
        }
        if (this.documentKey == null || this.documentKey.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cDocument Key\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("document_id", this.documentId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.FORM;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("document_key", String.valueOf(this.documentKey)));
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetDocumentStatusNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetDocumentStatusNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

