/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getlanguages;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

class GetLanguagesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Type", description="Enable to set the optional field <b>Type</b>")
    @ValueReference(value=TypeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean typeEnabled = false;
    @Widget(title="Type", description="\t<p>Sets whether source or target languages should be listed. Possible options are:</p>\n<ul>\n<li><tt>source</tt> (default): For languages that can be used in the <tt>source_lang</tt> parameter of <a href=\"https://www.deepl.com/docs-api/translate-text/translate-text\">translate</a> requests.</li>\n<li><tt>target</tt>: For languages that can be used in the <tt>target_lang</tt> parameter of <a href=\"https://www.deepl.com/docs-api/translate-text/translate-text\">translate</a> requests.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TypeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=TypeChoicesProvider.class)
    String type = "source";
    private static final String[] TYPE_VALUES = new String[]{"source", "target"};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Language:</b> The language code of the given language.</li>\n\t<li><b>Name:</b> Name of the language in English.</li>\n\t<li><b>Supports Formality:</b> Denotes formality support in case of a target language listing.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetLanguagesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"language\":\"rows[#2][0]\",\"name\":\"rows[#2][1]\",\"supports_formality\":\"rows[#2][2]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Supports Formality", BooleanCell.BooleanCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetLanguagesNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.typeEnabled) {
            params.add(new HttpRequestNodeParameters.Param("type", this.type));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetLanguagesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetLanguagesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class TypeChoicesProvider
    implements StringChoicesProvider {
        private TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TYPE_VALUES);
        }
    }

    private static final class TypeEnabledRef
    implements BooleanReference {
        private TypeEnabledRef() {
        }
    }
}

