/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.getmultilingualglossaryentries;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetMultilingualGlossaryEntriesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Source Language", description="The language in which the source texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Source_LangChoicesProvider.class)
    String sourceLang = SOURCE_LANG_VALUES[0];
    private static final String[] SOURCE_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Target Language", description="The language in which the target texts in the glossary are specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Target_LangChoicesProvider.class)
    String targetLang = TARGET_LANG_VALUES[0];
    private static final String[] TARGET_LANG_VALUES = new String[]{"ar", "bg", "cs", "da", "de", "el", "en", "es", "et", "fi", "fr", "he", "hu", "id", "it", "ja", "ko", "lt", "lv", "nb", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sv", "th", "tr", "uk", "vi", "zh"};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Source Language:</b> The language in which the source texts in the glossary are specified.</li>\n\t\t<li><b>Target Language:</b> The language in which the target texts in the glossary are specified.</li>\n\t\t<li><b>Entries:</b> The entries of the glossary. The entries have to be specified in the format provided by the <tt>entries_format</tt> parameter.</li>\n\t\t<li><b>Entries Format:</b> <p>The format in which the glossary entries are provided. Formats currently available:</p>\n<ul>\n<li><tt>tsv</tt> (default) - tab-separated values</li>\n<li><tt>csv</tt> - comma-separated values</li>\n</ul>\n<p>See <a href=\"https://www.deepl.com/docs-api/glossaries/formats\">Supported Glossary Formats</a> for details about each format.</p></li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetMultilingualGlossaryEntriesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"source_lang\":\"rows[0][0]\",\"target_lang\":\"rows[0][1]\",\"entries\":\"rows[0][2]\",\"entries_format\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Source Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Target Language", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entries", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Entries Format", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetMultilingualGlossaryEntriesNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.sourceLang == null || this.sourceLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSource Language\u201d is required.");
        }
        if (this.targetLang == null || this.targetLang.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cTarget Language\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("glossary_id", this.glossaryId));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("source_lang", this.sourceLang));
        params.add(new HttpRequestNodeParameters.Param("target_lang", this.targetLang));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetMultilingualGlossaryEntriesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetMultilingualGlossaryEntriesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Source_LangChoicesProvider
    implements StringChoicesProvider {
        private Source_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SOURCE_LANG_VALUES);
        }
    }

    private static final class Target_LangChoicesProvider
    implements StringChoicesProvider {
        private Target_LangChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TARGET_LANG_VALUES);
        }
    }
}

