/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.deepl.v2.operation.patchmultilingualglossary;

import com.nodepit.nodes.deepl.v2.HttpRequestNodeParameters;
import com.nodepit.nodes.deepl.v2.NodeParametersUtils;
import com.nodepit.nodes.deepl.v2.ResponseMapper;
import com.nodepit.nodes.deepl.v2.SimpleResponseMapper;
import com.nodepit.nodes.deepl.v2.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class PatchMultilingualGlossaryNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Glossary ID", description="A unique ID assigned to the glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String glossaryId = null;
    @Widget(title="Set Name", description="Enable to set the optional field <b>Name</b>")
    @ValueReference(value=NameEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nameEnabled = false;
    @Widget(title="Name", description="A unique ID assigned to a glossary.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NameEnabledRef.class, type=Effect.EffectType.SHOW)
    String name = null;
    @Widget(title="Set Dictionaries", description="Enable to set the optional field <b>Dictionaries</b>")
    @ValueReference(value=DictionariesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean dictionariesEnabled = false;
    @Widget(title="Dictionaries", description="Dictionaries to edit the glossary with. Currently only supports 0 or 1 dictionaries in the array.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DictionariesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=DictionariesPersistor.class)
    Dictionaries[] dictionaries = new Dictionaries[]{new Dictionaries(null)};
    @Widget(title="Result Format", description="\t<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n\t<p><b>Structured Table:</b> Returns a parsed table with data split into rows\n\tand columns.</p>\n\t<ul>\n\t\t<li><b>Glossary ID:</b> A unique ID assigned to a glossary.</li>\n\t\t<li><b>Name:</b> Name associated with the glossary.</li>\n\t\t<li><b>Dictionaries:</b> List of dictionaries contained in this glossary.\nEach dictionary contains a source and target language, as well as pairs of source and target entries.</li>\n\t\t<li><b>Creation Time:</b> The creation time of the glossary in the ISO 8601-1:2019 format (e.g.: <tt>2021-08-03T14:16:18.329Z</tt>).</li>\n\t</ul>\n\t<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n\t<ul>\n\t\t<li><b>body:</b> Response body</li>\n\t\t<li><b>status:</b> HTTP status code</li>\n\t</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=PatchMultilingualGlossaryNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"glossary_id\":\"rows[0][0]\",\"name\":\"rows[0][1]\",\"dictionaries\":\"rows[0][2]\",\"creation_time\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Glossary ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Dictionaries", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Creation Time", ZonedDateTimeCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    PatchMultilingualGlossaryNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.glossaryId == null || this.glossaryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cGlossary ID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("glossary_id", this.glossaryId));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.FORM;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getBodyParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.nameEnabled) {
            params.add(new HttpRequestNodeParameters.Param("name", String.valueOf(this.name)));
        }
        if (this.dictionariesEnabled) {
            Arrays.stream(this.dictionaries).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("dictionaries", value.text));
            });
        }
        return params;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    static final class Dictionaries
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Dictionaries() {
        }

        Dictionaries(String text) {
            this.text = text;
        }
    }

    private static final class DictionariesEnabledRef
    implements BooleanReference {
        private DictionariesEnabledRef() {
        }
    }

    private static final class DictionariesPersistor
    implements NodeParametersPersistor<Dictionaries[]> {
        static final String CONFIG_KEY = "dictionaries";

        private DictionariesPersistor() {
        }

        public Dictionaries[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Dictionaries[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Dictionaries::new).toArray(Dictionaries[]::new);
        }

        public void save(Dictionaries[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class NameEnabledRef
    implements BooleanReference {
        private NameEnabledRef() {
        }
    }

    private static final class PatchMultilingualGlossaryNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private PatchMultilingualGlossaryNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

