/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DropboxPicker
extends JDialog {
    private final NodeType type;
    private final JTree fileTree;
    private final JButton chooseButton;
    private DbxNode selection;

    public DropboxPicker(Frame owner, NodeType type, DbxClientV2 client) {
        super(owner, "Dropbox Picker", true);
        this.type = type;
        DbxTreeModel treeModel = new DbxTreeModel(client);
        this.fileTree = new JTree(treeModel);
        this.fileTree.getSelectionModel().setSelectionMode(1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.fileTree), "Center");
        JPanel panel = new JPanel();
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(e -> {
            DbxNode selection = (DbxNode)this.fileTree.getLastSelectedPathComponent();
            treeModel.refresh(selection);
        });
        panel.add(refreshButton);
        panel.add(new JLabel("       "));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.setVisible(false));
        panel.add(cancelButton);
        this.chooseButton = new JButton("Choose");
        this.chooseButton.addActionListener(e -> {
            this.selection = (DbxNode)this.fileTree.getLastSelectedPathComponent();
            this.setVisible(false);
        });
        panel.add(this.chooseButton);
        this.getContentPane().add((Component)panel, "South");
        this.fileTree.addTreeSelectionListener(event -> {
            DbxNode selection = (DbxNode)this.fileTree.getLastSelectedPathComponent();
            this.chooseButton.setEnabled(selection != null && this.canPick(selection));
        });
        this.chooseButton.setEnabled(false);
        this.setSize(500, 500);
        this.setLocationRelativeTo(null);
        this.fileTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DbxNode node = (DbxNode)value;
                boolean enabled = DropboxPicker.this.canPick(node);
                Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setEnabled(enabled);
                Icon disabledIcon = node.getType() == NodeType.FILE ? this.getDefaultLeafIcon() : (expanded ? this.getDefaultOpenIcon() : this.getDefaultClosedIcon());
                this.setDisabledIcon(disabledIcon);
                return component;
            }
        });
    }

    public String getSelection() {
        return this.selection != null ? this.selection.getPath() : null;
    }

    public void setSelection(String path) {
        DbxNode root;
        DbxNode selected = root = (DbxNode)this.fileTree.getModel().getRoot();
        String[] split = Optional.ofNullable(path).orElse("").split("/");
        int idx = 1;
        while (idx < split.length) {
            String currentPath = "/" + Arrays.stream(split).skip(1L).limit(idx).collect(Collectors.joining("/"));
            Optional<DbxNode> child = selected.getChildren().stream().filter(node -> node.getPath().equals(currentPath)).findFirst();
            if (!child.isPresent()) {
                selected = root;
                break;
            }
            selected = child.get();
            ++idx;
        }
        this.fileTree.setExpandsSelectedPaths(true);
        this.fileTree.setSelectionPath(selected.getTreePath());
    }

    private boolean canPick(DbxNode selection) {
        return selection.getType() == this.type || this.type == NodeType.FILE_OR_FOLDER;
    }

    private static final class DbxNode
    implements Comparable<DbxNode> {
        private final DbxClientV2 client;
        private final DbxNode parent;
        private final Metadata metadata;
        private List<DbxNode> children;

        DbxNode(DbxClientV2 client, DbxNode parent, Metadata metadata) {
            this.client = client;
            this.parent = parent;
            this.metadata = metadata;
        }

        public NodeType getType() {
            if (this.metadata == null) {
                return NodeType.FOLDER;
            }
            if (this.metadata instanceof FolderMetadata) {
                return NodeType.FOLDER;
            }
            return NodeType.FILE;
        }

        public String getName() {
            return this.metadata == null ? "Dropbox" : this.metadata.getName();
        }

        public String getPath() {
            return this.metadata == null ? "" : this.metadata.getPathLower();
        }

        public String toString() {
            return this.getName();
        }

        public List<DbxNode> getChildren() {
            if (this.children == null) {
                this.children = this.loadChildren();
            }
            return this.children;
        }

        public void reload() {
            this.children = this.loadChildren();
        }

        private List<DbxNode> loadChildren() {
            try {
                ArrayList<DbxNode> list = new ArrayList<DbxNode>();
                ListFolderResult result = this.client.files().listFolder(this.getPath());
                while (true) {
                    result.getEntries().forEach(entry -> {
                        boolean bl = list.add(new DbxNode(this.client, this, (Metadata)entry));
                    });
                    if (!result.getHasMore()) break;
                    result = this.client.files().listFolderContinue(result.getCursor());
                }
                Collections.sort(list);
                return list;
            }
            catch (ListFolderErrorException listFolderErrorException) {
                return Collections.emptyList();
            }
            catch (DbxException e) {
                throw new IllegalStateException("Error while listing " + this.getPath(), e);
            }
        }

        public TreePath getTreePath() {
            return this.parent == null ? new TreePath(this) : this.parent.getTreePath().pathByAddingChild(this);
        }

        @Override
        public int compareTo(DbxNode o) {
            return this.getName().compareToIgnoreCase(o.getName());
        }

        public int hashCode() {
            return Objects.hash(this.metadata);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DbxNode other = (DbxNode)obj;
            return Objects.equals(this.metadata, other.metadata);
        }
    }

    private static final class DbxTreeModel
    implements TreeModel {
        private final DbxNode rootPath;
        private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        DbxTreeModel(DbxClientV2 client) {
            this.rootPath = new DbxNode(client, null, null);
        }

        @Override
        public Object getRoot() {
            return this.rootPath;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((DbxNode)parent).getChildren().get(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((DbxNode)parent).getChildren().size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((DbxNode)node).getType() == NodeType.FILE;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((DbxNode)parent).getChildren().indexOf(child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object value) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        public void refresh(Object node) {
            DbxNode dbxNode = node != null ? (DbxNode)node : this.rootPath;
            if (dbxNode.getType() == NodeType.FILE) {
                dbxNode = (DbxNode)dbxNode.getTreePath().getParentPath().getLastPathComponent();
            }
            List<DbxNode> before = dbxNode.getChildren();
            dbxNode.reload();
            List<DbxNode> after = dbxNode.getChildren();
            ArrayList<DbxNode> remove = new ArrayList<DbxNode>();
            ArrayList<Integer> removeIdx = new ArrayList<Integer>();
            int idx = 0;
            while (idx < before.size()) {
                DbxNode current = before.get(idx);
                if (!after.contains(current)) {
                    remove.add(current);
                    removeIdx.add(idx);
                }
                ++idx;
            }
            if (!remove.isEmpty()) {
                TreeModelEvent removeEvent = new TreeModelEvent((Object)this, dbxNode.getTreePath().getParentPath(), removeIdx.stream().mapToInt(Integer::intValue).toArray(), remove.toArray());
                this.listeners.forEach(listener -> listener.treeNodesRemoved(removeEvent));
            }
            ArrayList<DbxNode> add = new ArrayList<DbxNode>();
            ArrayList<Integer> addIdx = new ArrayList<Integer>();
            int idx2 = 0;
            while (idx2 < after.size()) {
                DbxNode current = after.get(idx2);
                if (!before.contains(current)) {
                    add.add(current);
                    addIdx.add(idx2);
                }
                ++idx2;
            }
            if (!add.isEmpty()) {
                TreeModelEvent addEvent = new TreeModelEvent((Object)this, dbxNode.getTreePath().getParentPath(), addIdx.stream().mapToInt(Integer::intValue).toArray(), add.toArray());
                this.listeners.forEach(listener -> listener.treeNodesInserted(addEvent));
            }
        }
    }

    public static enum NodeType {
        FILE,
        FOLDER,
        FILE_OR_FOLDER;

    }
}

