/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox;

import com.nodepit.knime.dropbox.Activator;
import com.nodepit.knime.dropbox.download.DropboxDownloadCache;
import java.io.IOException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.osgi.framework.Bundle;

public class DropboxPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CACHE_SIZE_MB_KEY = "cacheSize";
    private static final ImageDescriptor DROPBOX_ICON = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("resources/dropbox.png"), null));

    public DropboxPreferencePage() {
        super(null, DROPBOX_ICON, 1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Label label = new Label(parent, 16448);
        label.setText("The nodes keep a cache in a directory .dropboxKnimeNodesCache within your home directory which stores recent downloads. This way, repeatedly requested files will not need to be downloaded again if they have not changed. If the size of the cache exceeds the specified limit, old files will be removed.");
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.addField((FieldEditor)new IntegerFieldEditor(CACHE_SIZE_MB_KEY, "Cache size (MB)", parent));
    }

    public boolean performOk() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    DropboxDownloadCache.pruneCache(new ExecutionMonitor());
                }
                catch (IOException | CanceledExecutionException throwable) {}
            }
        }, 1000L);
        return super.performOk();
    }
}

