/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.connect;

import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObjectSpec;
import java.io.File;
import java.io.IOException;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class DropboxConnectorNodeModel
extends NodeModel {
    private static final String CFGKEY_ACCESS_TOKEN = "accessToken";
    private final SettingsModelString settingsModelAccessToken = DropboxConnectorNodeModel.createSettingsModelAccessToken();

    public static SettingsModelString createSettingsModelAccessToken() {
        return new SettingsModelString(CFGKEY_ACCESS_TOKEN, null);
    }

    public DropboxConnectorNodeModel() {
        super(new PortType[0], new PortType[]{DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        AbstractDropboxConnectorPortObjectSpec spec = this.createPortObjectSpec();
        return new PortObject[]{DropboxConnectorPortObject.forSpec(spec)};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.createPortObjectSpec()};
    }

    private AbstractDropboxConnectorPortObjectSpec createPortObjectSpec() throws InvalidSettingsException {
        String accessToken = this.settingsModelAccessToken.getStringValue();
        if (accessToken == null || accessToken.isEmpty()) {
            throw new InvalidSettingsException("Missing access token. Please configure the node.");
        }
        return new DropboxConnectorPortObjectSpec(accessToken);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelAccessToken.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelAccessToken.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelAccessToken.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

