/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.connect.oauth2;

import com.github.scribejava.apis.DropboxApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.nodepit.knime.dropbox.connect.oauth2.DropboxOAuthConnector2NodeModel;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.SettingsModelLong;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

class DropboxOAuthConnector2NodeDialog
extends DefaultNodeSettingsPane {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DropboxOAuthConnector2NodeDialog.class);
    private static final int PORT = 55931;
    private static final String REDIRECT_URI = "http://localhost:55931";
    private static final OAuth20Service OAUTH_SERVICE = new ServiceBuilder("ahviff37pooa3cn").apiSecret("4yio7bp0i7c2fnk").callback("http://localhost:55931").build((DefaultApi20)DropboxApiOfflineToken.instance());
    private static Server server;
    private final SettingsModelString accessToken = DropboxOAuthConnector2NodeModel.createSettingsModelAccessToken();
    private final SettingsModelLong expiresAt = DropboxOAuthConnector2NodeModel.createSettingsModelExpiresAt();
    private final SettingsModelString refreshToken = DropboxOAuthConnector2NodeModel.createSettingsModelRefreshToken();
    private final DialogComponentLabel refreshTokenLabel = new DialogComponentLabel("");
    private final DialogComponentButtonFix deleteTokenButton;

    DropboxOAuthConnector2NodeDialog() {
        this.addDialogComponent((DialogComponent)this.refreshTokenLabel);
        this.setHorizontalPlacement(true);
        DialogComponentButton refreshTokenButton = new DialogComponentButton("Authorize Access");
        this.addDialogComponent((DialogComponent)refreshTokenButton);
        this.deleteTokenButton = new DialogComponentButtonFix("Clear Token");
        this.addDialogComponent((DialogComponent)this.deleteTokenButton);
        refreshTokenButton.addActionListener(e -> new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DropboxOAuthConnector2NodeDialog.this.startServerIfNotYetRunning();
                }
                catch (Exception e) {
                    DropboxOAuthConnector2NodeDialog.this.updateStatus("Could not start HTTP server on port 55931: " + e.getMessage(), e);
                    return null;
                }
                Desktop.getDesktop().browse(new URI(OAUTH_SERVICE.getAuthorizationUrl()));
                DropboxOAuthConnector2NodeDialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                return null;
            }
        }.execute());
        this.deleteTokenButton.addActionListener(e -> {
            this.accessToken.setStringValue(null);
            this.expiresAt.setLongValue(-1L);
            this.refreshToken.setStringValue(null);
            this.updateLabel();
        });
        this.refreshToken.addChangeListener(e -> this.updateDeleteTokenState());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        try {
            this.refreshToken.loadSettingsFrom(settings);
            this.updateLabel();
            this.accessToken.loadSettingsFrom(settings);
            this.expiresAt.loadSettingsFrom(settings);
            this.updateDeleteTokenState();
        }
        catch (InvalidSettingsException e) {
            LOGGER.debug((Object)"Encountered ISE", (Throwable)e);
        }
    }

    private void updateDeleteTokenState() {
        boolean enabled = this.refreshToken.getStringValue() != null && !this.refreshToken.getStringValue().isEmpty();
        this.deleteTokenButton.setEnabledComponents(enabled);
    }

    private void updateLabel() {
        String msg = this.refreshToken.getStringValue() != null ? "Authenticated successfully" : "Click the button to request a refresh token.";
        this.refreshTokenLabel.setText(msg);
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.accessToken.saveSettingsTo(settings);
        this.expiresAt.saveSettingsTo(settings);
        this.refreshToken.saveSettingsTo(settings);
    }

    public void onClose() {
        this.stopServerIfRunning();
    }

    private void startServerIfNotYetRunning() throws Exception {
        if (server != null && server.isRunning()) {
            LOGGER.debug((Object)"Server is already running");
            return;
        }
        server = new Server(55931);
        server.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                LOGGER.debugWithFormat(request.toString(), new Object[0]);
                if (request.getHttpURI().getPath().equals("/") && request.getHttpURI().getQuery().startsWith("code=")) {
                    String code = request.getHttpURI().getQuery().replaceAll("^code=", "");
                    DropboxOAuthConnector2NodeDialog.this.receivedCode(code);
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)DropboxOAuthConnector2NodeDialog.getAccessGrantedHtml(), (Callback)callback);
                } else if (!request.getHttpURI().getPath().equals("/") || !request.getHttpURI().getQuery().contains("error=")) {
                    response.setStatus(404);
                }
                return true;
            }
        });
        this.updateStatus("Starting HTTP server on 55931", null);
        server.start();
    }

    private void stopServerIfRunning() {
        if (server != null && server.isRunning()) {
            try {
                this.updateStatus("Stopping running server", null);
                server.stop();
                server = null;
            }
            catch (Exception e) {
                this.updateStatus("Error: Could not stop running server", e);
            }
        }
    }

    private void updateStatus(String message, Exception ex) {
        this.refreshTokenLabel.setText(message);
        if (ex != null) {
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            LOGGER.info((Object)message);
        }
    }

    private void receivedCode(String code) {
        this.updateStatus("Authorization code: " + code, null);
        try {
            OAuth2AccessToken accessTokenResult = OAUTH_SERVICE.getAccessToken(code);
            String refreshToken = accessTokenResult.getRefreshToken();
            this.updateStatus("Refresh token: " + refreshToken, null);
            this.accessToken.setStringValue(accessTokenResult.getAccessToken());
            this.expiresAt.setLongValue(System.currentTimeMillis() + (long)(accessTokenResult.getExpiresIn() * 1000));
            this.refreshToken.setStringValue(refreshToken);
        }
        catch (Exception e) {
            this.updateStatus("Could not get refresh token: " + e.getMessage(), e);
        }
    }

    private static String getAccessGrantedHtml() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DropboxOAuthConnector2NodeDialog.class.getResourceAsStream("AccessGranted.html"), StandardCharsets.UTF_8));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class DialogComponentButtonFix
    extends DialogComponentButton {
        public DialogComponentButtonFix(String label) {
            super(label);
        }

        public void setEnabledComponents(boolean enabled) {
            super.setEnabledComponents(enabled);
        }
    }

    private static class DropboxApiOfflineToken
    extends DropboxApi {
        public static DropboxApi instance() {
            return InstanceHolder.INSTANCE;
        }

        private DropboxApiOfflineToken() {
        }

        protected String getAuthorizationBaseUrl() {
            return "https://www.dropbox.com/oauth2/authorize?token_access_type=offline";
        }

        private static class InstanceHolder {
            private static final DropboxApiOfflineToken INSTANCE = new DropboxApiOfflineToken();

            private InstanceHolder() {
            }
        }
    }
}

