/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.connect.oauth2;

import com.nodepit.knime.dropbox.port.DropboxConnector2PortObjectSpec;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelLong;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class DropboxOAuthConnector2NodeModel
extends NodeModel {
    private static final String CFGKEY_ACCESS_TOKEN = "accessToken";
    private static final String CFGKEY_EXPIRES_AT = "expiresAt";
    private static final String CFGKEY_REFRESH_TOKEN = "refreshToken";
    private final SettingsModelString settingsModelAccessToken = DropboxOAuthConnector2NodeModel.createSettingsModelAccessToken();
    private final SettingsModelLong settingsModelExpiresAt = DropboxOAuthConnector2NodeModel.createSettingsModelExpiresAt();
    private final SettingsModelString settingsModelRefreshToken = DropboxOAuthConnector2NodeModel.createSettingsModelRefreshToken();

    public static SettingsModelString createSettingsModelAccessToken() {
        return new SettingsModelString(CFGKEY_ACCESS_TOKEN, null);
    }

    public static SettingsModelLong createSettingsModelExpiresAt() {
        return new SettingsModelLong(CFGKEY_EXPIRES_AT, -1L);
    }

    public static SettingsModelString createSettingsModelRefreshToken() {
        return new SettingsModelString(CFGKEY_REFRESH_TOKEN, null);
    }

    public DropboxOAuthConnector2NodeModel() {
        super(new PortType[0], new PortType[]{DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnector2PortObjectSpec spec = this.createPortObjectSpec();
        return new PortObject[]{DropboxConnectorPortObject.forSpec(spec)};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.createPortObjectSpec()};
    }

    private DropboxConnector2PortObjectSpec createPortObjectSpec() throws InvalidSettingsException {
        String accessToken = this.settingsModelAccessToken.getStringValue();
        if (accessToken == null || accessToken.isEmpty()) {
            throw new InvalidSettingsException("Missing access token. Please configure the node.");
        }
        long expiresAt = this.settingsModelExpiresAt.getLongValue();
        if (expiresAt == -1L) {
            throw new InvalidSettingsException("Missing expires. Please configure the node.");
        }
        String refreshToken = this.settingsModelRefreshToken.getStringValue();
        if (refreshToken == null || refreshToken.isEmpty()) {
            throw new InvalidSettingsException("Missing refresh token. Please configure the node.");
        }
        return new DropboxConnector2PortObjectSpec(accessToken, expiresAt, refreshToken);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelAccessToken.saveSettingsTo(settings);
        this.settingsModelExpiresAt.saveSettingsTo(settings);
        this.settingsModelRefreshToken.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelAccessToken.validateSettings(settings);
        this.settingsModelExpiresAt.validateSettings(settings);
        this.settingsModelRefreshToken.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelAccessToken.loadSettingsFrom(settings);
        this.settingsModelExpiresAt.loadSettingsFrom(settings);
        this.settingsModelRefreshToken.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

