/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.download;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.nodepit.knime.dropbox.Activator;
import com.nodepit.knime.dropbox.CancelledExecutionRuntimeException;
import com.nodepit.knime.dropbox.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.preference.IPreferenceStore;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.NodeLogger;

public final class DropboxDownloadCache {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DropboxDownloadCache.class);
    public static final String CACHE_DIR_NAME = ".dropboxKnimeNodesCache";
    private static final Path CACHE_DIR_PATH = Paths.get(System.getProperty("user.home"), ".dropboxKnimeNodesCache");
    private static final String DOWNLOAD_FILE_EXTENSION = ".downloading";

    public static CacheResult getFromCacheOrDownload(DbxClientV2 client, String path, String target, ExecutionContext exec) throws DbxException, IOException, CanceledExecutionException {
        Files.createDirectories(CACHE_DIR_PATH, new FileAttribute[0]);
        FileMetadata metadata = (FileMetadata)client.files().getMetadata(path);
        String remoteHash = metadata.getContentHash();
        File targetDirectory = Utils.getFileFromUrlOrPath(target);
        Path cachedFile = Paths.get(CACHE_DIR_PATH.toString(), remoteHash);
        Path resultFile = Paths.get(targetDirectory.toPath().toString(), metadata.getName());
        if (Files.exists(cachedFile, new LinkOption[0])) {
            LOGGER.infoWithFormat("Cache hit for %s", new Object[]{remoteHash});
            String cachedHash = DropboxDownloadCache.dropboxHash(cachedFile);
            if (remoteHash.equals(cachedHash)) {
                Files.copy(cachedFile, resultFile, StandardCopyOption.REPLACE_EXISTING);
                Files.setLastModifiedTime(cachedFile, FileTime.from(Instant.now()));
                Files.setLastModifiedTime(resultFile, FileTime.fromMillis(metadata.getClientModified().getTime()));
                return new CacheResult(resultFile.toFile(), metadata);
            }
            LOGGER.debugWithFormat("Hashes do not match; expected %s, got %s", new Object[]{remoteHash, cachedHash});
        }
        DbxDownloader downloader = client.files().download(path);
        long totalBytes = ((FileMetadata)downloader.getResult()).getSize();
        Path downloadFile = Paths.get(CACHE_DIR_PATH.toString(), remoteHash + DOWNLOAD_FILE_EXTENSION);
        Throwable throwable = null;
        Object var14_14 = null;
        try (FileOutputStream out = new FileOutputStream(downloadFile.toFile());){
            metadata = (FileMetadata)downloader.download((OutputStream)out, bytesWritten -> {
                try {
                    exec.checkCanceled();
                }
                catch (CanceledExecutionException e) {
                    throw new CancelledExecutionRuntimeException(e);
                }
                exec.setProgress((double)bytesWritten / (double)totalBytes, () -> "Downloaded " + Utils.humanReadableByteCountSI(bytesWritten) + " / " + Utils.humanReadableByteCountSI(totalBytes));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.move(downloadFile, cachedFile, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(cachedFile, resultFile, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(resultFile, FileTime.fromMillis(metadata.getClientModified().getTime()));
        LOGGER.infoWithFormat("Downloaded file: %s", new Object[]{metadata});
        DropboxDownloadCache.pruneCache((ExecutionMonitor)exec);
        return new CacheResult(resultFile.toFile(), metadata);
    }

    private static String dropboxHash(Path file) throws IOException {
        Utils.DropboxContentHasher hasher = new Utils.DropboxContentHasher();
        byte[] buf = new byte[1024];
        try (FileInputStream in = new FileInputStream(file.toFile());){
            int n;
            while ((n = ((InputStream)in).read(buf)) >= 0) {
                hasher.update(buf, 0, n);
            }
        }
        byte[] rawHash = hasher.digest();
        return Utils.hex(rawHash);
    }

    public static void pruneCache(ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        List filesInCache = Files.list(CACHE_DIR_PATH).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(p -> !p.getFileName().toString().endsWith(DOWNLOAD_FILE_EXTENSION)).sorted(Comparator.comparing(p -> p.toFile().lastModified())).collect(Collectors.toList());
        long maxCacheSize = DropboxDownloadCache.getMaxCacheSizeBytes();
        Long currentCacheSize = filesInCache.stream().collect(Collectors.summingLong(p -> p.toFile().length()));
        while (currentCacheSize > maxCacheSize && !filesInCache.isEmpty()) {
            exec.setMessage("Pruning cache " + Utils.humanReadableByteCountSI(currentCacheSize));
            exec.checkCanceled();
            Path oldestFile = (Path)filesInCache.remove(0);
            long oldestFileSize = oldestFile.toFile().length();
            try {
                Files.delete(oldestFile);
                LOGGER.debugWithFormat("Deleted %s (%s bytes)", new Object[]{oldestFile, Utils.humanReadableByteCountSI(oldestFileSize)});
                currentCacheSize = currentCacheSize - oldestFileSize;
            }
            catch (IOException e) {
                LOGGER.debugWithFormat("Could not delete %s (%s bytes): %s", new Object[]{oldestFile, Utils.humanReadableByteCountSI(oldestFileSize), e});
            }
        }
        LOGGER.debugWithFormat("Size of cache is %s -- no further pruning needed", new Object[]{Utils.humanReadableByteCountSI(currentCacheSize)});
    }

    private static long getMaxCacheSizeBytes() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getLong("cacheSize") * 1000L * 1000L;
    }

    private DropboxDownloadCache() {
    }

    public static final class CacheResult {
        public final File file;
        public final FileMetadata meta;

        CacheResult(File file, FileMetadata meta) {
            this.file = file;
            this.meta = meta;
        }
    }
}

