/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.download;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.Metadata;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.download.DropboxDownloadCache;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class DropboxDownloadNodeModel
extends NodeModel {
    private static final MetadataMapper MAPPER = MetadataMapper.DEFAULT;
    static final String CFGKEY_PATH = "path";
    static final String CFGKEY_TARGET_DIRECTORY = "destinationDirectory";
    private final SettingsModelString settingsModelPath = DropboxDownloadNodeModel.createSettingsModelPath();
    private final SettingsModelString settingsModelTargetDirectory = DropboxDownloadNodeModel.createSettingsModelTargetDirectory();

    static SettingsModelString createSettingsModelPath() {
        return new SettingsModelString(CFGKEY_PATH, "");
    }

    static SettingsModelString createSettingsModelTargetDirectory() {
        return new SettingsModelString(CFGKEY_TARGET_DIRECTORY, null);
    }

    protected DropboxDownloadNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        DropboxDownloadCache.CacheResult result = DropboxDownloadCache.getFromCacheOrDownload(client, this.settingsModelPath.getStringValue(), this.settingsModelTargetDirectory.getStringValue(), exec);
        DataTableSpec tableSpec = DropboxDownloadNodeModel.createSpec();
        BufferedDataContainer container = exec.createDataContainer(tableSpec);
        ArrayList<DataCell> cells = new ArrayList<DataCell>();
        cells.addAll(MAPPER.map((Metadata)result.meta));
        cells.add(Utils.createStringOrMissing(result.file.getAbsolutePath()));
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), cells));
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    private static DataTableSpec createSpec() {
        return new DataTableSpecCreator(MAPPER.getSpec()).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("localFile", StringCell.TYPE).createSpec()}).createSpec();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{DropboxDownloadNodeModel.createSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelPath.saveSettingsTo(settings);
        this.settingsModelTargetDirectory.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.validateSettings(settings);
        this.settingsModelTargetDirectory.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.loadSettingsFrom(settings);
        this.settingsModelTargetDirectory.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

