/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.list;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class DropboxListNodeModel
extends NodeModel {
    static final String CFGKEY_PATH = "path";
    private static final String CFGKEY_ALL_PROPERTIES = "allProperties";
    private final SettingsModelString settingsModelPath = DropboxListNodeModel.createSettingsModelPath();
    private final SettingsModelBoolean settingsModelAllProperties = DropboxListNodeModel.createSettingsModelAllProperties();

    static SettingsModelString createSettingsModelPath() {
        return new SettingsModelString(CFGKEY_PATH, "");
    }

    static SettingsModelBoolean createSettingsModelAllProperties() {
        return new SettingsModelBoolean(CFGKEY_ALL_PROPERTIES, false);
    }

    protected DropboxListNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        ListFolderResult result = client.files().listFolder(this.settingsModelPath.getStringValue());
        MetadataMapper mapper = this.getMapper();
        BufferedDataContainer container = exec.createDataContainer(mapper.getSpec());
        long rowIndex = 0L;
        while (true) {
            for (Metadata metadata : result.getEntries()) {
                container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)rowIndex++), mapper.map(metadata)));
            }
            if (!result.getHasMore()) break;
            result = client.files().listFolderContinue(result.getCursor());
        }
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.getMapper().getSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelPath.saveSettingsTo(settings);
        this.settingsModelAllProperties.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.validateSettings(settings);
        this.settingsModelAllProperties.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.loadSettingsFrom(settings);
        this.settingsModelAllProperties.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private MetadataMapper getMapper() {
        boolean all = this.settingsModelAllProperties.getBooleanValue();
        return all ? MetadataMapper.ALL : MetadataMapper.DEFAULT;
    }
}

