/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.port;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.port.AbstractSimplePortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.PortTypeRegistry;

public class DropboxConnectorPortObject
extends AbstractSimplePortObject {
    public static final PortType TYPE = PortTypeRegistry.getInstance().getPortType(DropboxConnectorPortObject.class);
    private static final String KEY_EMAIL = "email";
    private AbstractDropboxConnectorPortObjectSpec spec;
    private String email;

    public DropboxConnectorPortObject() {
    }

    public DropboxConnectorPortObject(AbstractDropboxConnectorPortObjectSpec spec, String email) {
        this.spec = spec;
        this.email = email;
    }

    public String getSummary() {
        return this.email;
    }

    public AbstractDropboxConnectorPortObjectSpec getSpec() {
        return this.spec;
    }

    protected void save(ModelContentWO model, ExecutionMonitor exec) throws CanceledExecutionException {
        model.addString(KEY_EMAIL, this.email);
    }

    protected void load(ModelContentRO model, PortObjectSpec spec, ExecutionMonitor exec) throws InvalidSettingsException, CanceledExecutionException {
        this.spec = (AbstractDropboxConnectorPortObjectSpec)spec;
        this.email = model.getString(KEY_EMAIL);
    }

    public static DropboxConnectorPortObject forSpec(AbstractDropboxConnectorPortObjectSpec spec) throws DbxException {
        DbxClientV2 client = spec.getClient();
        String email = client.users().getCurrentAccount().getEmail();
        return new DropboxConnectorPortObject(spec, email);
    }

    public static class Serializer
    extends AbstractSimplePortObject.AbstractSimplePortObjectSerializer<DropboxConnectorPortObject> {
    }
}

