/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.rename;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.RelocationResult;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class DropboxRenameNodeModel
extends NodeModel {
    private static final MetadataMapper MAPPER = MetadataMapper.DEFAULT;
    static final String CFGKEY_PATH = "path";
    static final String CFGKEY_NEW_NAME = "newName";
    private final SettingsModelString settingsModelPath = DropboxRenameNodeModel.createSettingsModelPath();
    private final SettingsModelString settingsModelNewName = DropboxRenameNodeModel.createSettingsModelNewName();

    static SettingsModelString createSettingsModelPath() {
        return new SettingsModelString(CFGKEY_PATH, "");
    }

    static SettingsModelString createSettingsModelNewName() {
        return new SettingsModelString(CFGKEY_NEW_NAME, null);
    }

    protected DropboxRenameNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        String parentPath = this.settingsModelPath.getStringValue().replaceAll("\\/[^\\/]*$", "");
        String fullTargetPath = parentPath + "/" + this.settingsModelNewName.getStringValue();
        RelocationResult result = client.files().moveV2(this.settingsModelPath.getStringValue(), fullTargetPath);
        Metadata metadata = result.getMetadata();
        BufferedDataContainer container = exec.createDataContainer(MAPPER.getSpec());
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), MAPPER.map(metadata)));
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        Utils.validateDropboxPathNotRoot(this.settingsModelPath.getStringValue());
        if (this.settingsModelNewName.getStringValue().isEmpty()) {
            throw new InvalidSettingsException("Please enter the new name.");
        }
        return new PortObjectSpec[]{MAPPER.getSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelPath.saveSettingsTo(settings);
        this.settingsModelNewName.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.validateSettings(settings);
        this.settingsModelNewName.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.loadSettingsFrom(settings);
        this.settingsModelNewName.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

