/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.search;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchMatchV2;
import com.dropbox.core.v2.files.SearchOptions;
import com.dropbox.core.v2.files.SearchV2Result;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class DropboxSearchNodeModel
extends NodeModel {
    static final String CFGKEY_PATH = "path";
    static final String CFGKEY_QUERY = "query";
    private static final String CFGKEY_ALL_PROPERTIES = "allProperties";
    private final SettingsModelString settingsModelPath = DropboxSearchNodeModel.createSettingsModelPath();
    private final SettingsModelString settingsModelQuery = DropboxSearchNodeModel.createSettingsModelQuery();
    private final SettingsModelBoolean settingsModelAllProperties = DropboxSearchNodeModel.createSettingsModelAllProperties();

    static SettingsModelString createSettingsModelPath() {
        return new SettingsModelString(CFGKEY_PATH, "");
    }

    static SettingsModelString createSettingsModelQuery() {
        return new SettingsModelString(CFGKEY_QUERY, "");
    }

    static SettingsModelBoolean createSettingsModelAllProperties() {
        return new SettingsModelBoolean(CFGKEY_ALL_PROPERTIES, false);
    }

    protected DropboxSearchNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        SearchV2Result result = client.files().searchV2Builder(this.settingsModelQuery.getStringValue()).withOptions(SearchOptions.newBuilder().withPath(this.settingsModelPath.getStringValue()).withMaxResults(Long.valueOf(1000L)).build()).start();
        MetadataMapper mapper = this.getMapper();
        BufferedDataContainer container = exec.createDataContainer(mapper.getSpec());
        long rowIndex = 0L;
        while (true) {
            for (SearchMatchV2 match : result.getMatches()) {
                Metadata metadata = match.getMetadata().getMetadataValue();
                container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)rowIndex++), mapper.map(metadata)));
            }
            if (!result.getHasMore()) break;
            result = client.files().searchContinueV2(result.getCursor());
        }
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        String query = this.settingsModelQuery.getStringValue();
        if (query == null || query.isEmpty()) {
            throw new InvalidSettingsException("Missing query. Please configure the node.");
        }
        return new PortObjectSpec[]{this.getMapper().getSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelPath.saveSettingsTo(settings);
        this.settingsModelQuery.saveSettingsTo(settings);
        this.settingsModelAllProperties.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.validateSettings(settings);
        this.settingsModelQuery.validateSettings(settings);
        this.settingsModelAllProperties.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelPath.loadSettingsFrom(settings);
        this.settingsModelQuery.loadSettingsFrom(settings);
        this.settingsModelAllProperties.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private MetadataMapper getMapper() {
        boolean all = this.settingsModelAllProperties.getBooleanValue();
        return all ? MetadataMapper.ALL : MetadataMapper.DEFAULT;
    }
}

