/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.upload;

import com.dropbox.core.DbxException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.RetryException;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishErrorException;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.WriteMode;
import com.nodepit.knime.dropbox.CancelledExecutionRuntimeException;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelLong;
import org.knime.core.node.defaultnodesettings.SettingsModelLongBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class DropboxUploadNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DropboxUploadNodeModel.class);
    static final String CFGKEY_PATH = "path";
    static final String CFGKEY_LOCAL_FILE = "localFile";
    private static final String CFGKEY_CHUNK_SIZE = "chunkSize";
    private static final String CFGKEY_ALL_PROPERTIES = "allProperties";
    private static final long DEFAULT_CHUNK_SIZE = 8192L;
    private static final long MIN_CHUNK_SIZE = 512L;
    private static final long MAX_CHUNK_SIZE = 51200L;
    private static final int CHUNKED_UPLOAD_MAX_ATTEMPTS = 5;
    private final SettingsModelString settingsModelRemoteDirectory = DropboxUploadNodeModel.createSettingsModelRemoteDirectoryPath();
    private final SettingsModelString settingsModelLocalFile = DropboxUploadNodeModel.createSettingsModelLocalFile();
    private final SettingsModelLong settingsModelChunkSizeKb = DropboxUploadNodeModel.createSettingsModelChunkSize();
    private final SettingsModelBoolean settingsModelAllProperties = DropboxUploadNodeModel.createSettingsModelAllProperties();

    static SettingsModelString createSettingsModelRemoteDirectoryPath() {
        return new SettingsModelString(CFGKEY_PATH, "");
    }

    static SettingsModelString createSettingsModelLocalFile() {
        return new SettingsModelString(CFGKEY_LOCAL_FILE, "");
    }

    static SettingsModelLong createSettingsModelChunkSize() {
        return new SettingsModelLongBounded(CFGKEY_CHUNK_SIZE, 8192L, 512L, 51200L);
    }

    static SettingsModelBoolean createSettingsModelAllProperties() {
        return new SettingsModelBoolean(CFGKEY_ALL_PROPERTIES, false);
    }

    protected DropboxUploadNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        FileMetadata metadata;
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        String path = this.settingsModelRemoteDirectory.getStringValue();
        File file = Utils.getFileFromUrlOrPath(this.settingsModelLocalFile.getStringValue());
        String fullPath = path + "/" + file.getName();
        long chunkSizeBytes = this.settingsModelChunkSizeKb.getLongValue() * 1024L;
        if (file.length() <= chunkSizeBytes) {
            LOGGER.debugWithFormat("%s bytes: Using normal upload", new Object[]{file.length()});
            metadata = DropboxUploadNodeModel.uploadFile(client, file, fullPath, exec);
        } else {
            LOGGER.debugWithFormat("%s bytes: Using chunked upload", new Object[]{file.length()});
            metadata = DropboxUploadNodeModel.chunkedUploadFile(client, file, fullPath, chunkSizeBytes, exec);
        }
        LOGGER.infoWithFormat("Uploaded file: %s", new Object[]{metadata});
        BufferedDataContainer container = exec.createDataContainer(this.createSpec());
        ArrayList<DataCell> cells = new ArrayList<DataCell>();
        cells.addAll(this.getMapper().map((Metadata)metadata));
        cells.add(Utils.createStringOrMissing(file.getAbsolutePath()));
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), cells));
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    private DataTableSpec createSpec() {
        return new DataTableSpecCreator(this.getMapper().getSpec()).addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(CFGKEY_LOCAL_FILE, StringCell.TYPE).createSpec()}).createSpec();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.createSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelRemoteDirectory.saveSettingsTo(settings);
        this.settingsModelLocalFile.saveSettingsTo(settings);
        this.settingsModelChunkSizeKb.saveSettingsTo(settings);
        this.settingsModelAllProperties.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelRemoteDirectory.validateSettings(settings);
        this.settingsModelLocalFile.validateSettings(settings);
        this.settingsModelChunkSizeKb.validateSettings(settings);
        this.settingsModelAllProperties.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelRemoteDirectory.loadSettingsFrom(settings);
        this.settingsModelLocalFile.loadSettingsFrom(settings);
        this.settingsModelChunkSizeKb.loadSettingsFrom(settings);
        this.settingsModelAllProperties.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private MetadataMapper getMapper() {
        boolean all = this.settingsModelAllProperties.getBooleanValue();
        return all ? MetadataMapper.ALL : MetadataMapper.DEFAULT;
    }

    private static FileMetadata uploadFile(DbxClientV2 dbxClient, File localFile, String dropboxPath, ExecutionContext exec) throws DbxException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(localFile);){
            return (FileMetadata)dbxClient.files().uploadBuilder(dropboxPath).withMode(WriteMode.ADD).withClientModified(new Date(localFile.lastModified())).uploadAndFinish((InputStream)in, l -> DropboxUploadNodeModel.progress(l, localFile.length(), exec));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static FileMetadata chunkedUploadFile(DbxClientV2 dbxClient, File localFile, String dropboxPath, final long chunkSize, final ExecutionContext exec) throws DbxException, IOException {
        final long size = localFile.length();
        if (size < chunkSize) {
            throw new IllegalArgumentException("File too small, use upload() instead.");
        }
        long uploaded = 0L;
        Throwable thrown = null;
        IOUtil.ProgressListener progressListener = new IOUtil.ProgressListener(){
            long uploadedBytes = 0L;

            public void onProgress(long l) {
                DropboxUploadNodeModel.progress(l + this.uploadedBytes, size, exec);
                if (l == chunkSize) {
                    this.uploadedBytes += chunkSize;
                }
            }
        };
        String sessionId = null;
        int i = 0;
        while (i < 5) {
            if (i > 0) {
                LOGGER.infoWithFormat("Retrying chunked upload (%d / %d attempts)", new Object[]{i + 1, 5});
            }
            try {
                Throwable throwable = null;
                Object var15_16 = null;
                try (FileInputStream in = new FileInputStream(localFile);){
                    ((InputStream)in).skip(uploaded);
                    if (sessionId == null) {
                        sessionId = ((UploadSessionStartResult)dbxClient.files().uploadSessionStart().uploadAndFinish((InputStream)in, chunkSize, progressListener)).getSessionId();
                        DropboxUploadNodeModel.progress(uploaded += chunkSize, size, exec);
                    }
                    UploadSessionCursor cursor = new UploadSessionCursor(sessionId, uploaded);
                    while (size - uploaded > chunkSize) {
                        LOGGER.debugWithFormat("Appending next chunk (uploaded %s / %s bytes)", new Object[]{uploaded, size});
                        dbxClient.files().uploadSessionAppendV2(cursor).uploadAndFinish((InputStream)in, chunkSize, progressListener);
                        DropboxUploadNodeModel.progress(uploaded += chunkSize, size, exec);
                        cursor = new UploadSessionCursor(sessionId, uploaded);
                    }
                    long remaining = size - uploaded;
                    CommitInfo commitInfo = CommitInfo.newBuilder((String)dropboxPath).withMode(WriteMode.ADD).withClientModified(new Date(localFile.lastModified())).build();
                    return (FileMetadata)dbxClient.files().uploadSessionFinish(cursor, commitInfo).uploadAndFinish((InputStream)in, remaining, progressListener);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RetryException ex) {
                thrown = ex;
                DropboxUploadNodeModel.sleepQuietly(ex.getBackoffMillis());
            }
            catch (NetworkIOException ex) {
                thrown = ex;
            }
            catch (UploadSessionFinishErrorException ex) {
                if (ex.errorValue.isLookupFailed() && ex.errorValue.getLookupFailedValue().isIncorrectOffset()) {
                    thrown = ex;
                    uploaded = ex.errorValue.getLookupFailedValue().getIncorrectOffsetValue().getCorrectOffset();
                }
                throw ex;
            }
            ++i;
        }
        throw new IllegalStateException("Maxed out upload attempts to Dropbox. Most recent error: " + thrown.getMessage());
    }

    private static void progress(long uploaded, long size, ExecutionContext exec) {
        exec.setProgress((double)uploaded / (double)size, () -> "Uploaded " + Utils.humanReadableByteCountSI(uploaded) + " / " + Utils.humanReadableByteCountSI(size));
        try {
            exec.checkCanceled();
        }
        catch (CanceledExecutionException e) {
            throw new CancelledExecutionRuntimeException(e);
        }
    }

    private static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Error uploading to Dropbox: interrupted during backoff.");
        }
    }
}

