/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox;

import com.dropbox.core.DbxException;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.FlowVariableModelButton;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

public class DialogComponentDbxPath
extends DialogComponent {
    private final JTextField textField;
    private final JButton browseButton;
    private final FlowVariableModelButton flowVariableModelButton;
    private final DropboxPicker.NodeType type;
    private AbstractDropboxConnectorPortObjectSpec spec;

    public DialogComponentDbxPath(SettingsModelString settingsModel, String label, DropboxPicker.NodeType type, FlowVariableModel fvm) {
        super((SettingsModel)settingsModel);
        this.type = type;
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), label);
        this.getComponentPanel().setBorder(border);
        this.getComponentPanel().setMaximumSize(new Dimension(Integer.MAX_VALUE, 74));
        this.textField = new JTextField();
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.textField.setPreferredSize(new Dimension(300, 25));
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogComponentDbxPath.this.updateModel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogComponentDbxPath.this.updateModel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DialogComponentDbxPath.this.updateModel();
            }
        });
        this.getComponentPanel().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 12;
        c.fill = 2;
        c.insets = new Insets(2, 5, 0, 0);
        this.getComponentPanel().add((Component)this.textField, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(2, 5, 0, 5);
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(e -> {
            DropboxPicker picker;
            Frame ownerFrame = (Frame)SwingUtilities.getWindowAncestor(this.getComponentPanel());
            try {
                picker = new DropboxPicker(ownerFrame, type, this.spec.getClient());
            }
            catch (DbxException ex) {
                JOptionPane.showMessageDialog(this.getComponentPanel(), ex.getMessage(), "Error", 0);
                return;
            }
            picker.setSelection(this.textField.getText());
            picker.setVisible(true);
            picker.dispose();
            if (picker.getSelection() != null) {
                this.textField.setText(picker.getSelection());
            }
        });
        this.getComponentPanel().add((Component)this.browseButton, c);
        this.flowVariableModelButton = new FlowVariableModelButton(fvm);
        c.gridx = 2;
        c.insets = new Insets(2, 0, 0, 5);
        this.getComponentPanel().add((Component)this.flowVariableModelButton, c);
        fvm.addChangeListener(e -> {
            boolean fvmEnabled = fvm.isVariableReplacementEnabled();
            this.textField.setEnabled(!fvmEnabled);
            this.browseButton.setEnabled(!fvmEnabled);
            if (fvmEnabled) {
                fvm.getVariableValue().ifPresent(fv -> this.textField.setText(fv.getStringValue()));
            }
        });
    }

    protected void updateComponent() {
        String stringValue = ((SettingsModelString)this.getModel()).getStringValue();
        if (!this.textField.getText().equals(stringValue)) {
            this.textField.setText(stringValue);
        }
        this.setEnabledComponents(this.getModel().isEnabled());
    }

    private void checkAndUpdateModel() throws InvalidSettingsException {
        if (this.type == DropboxPicker.NodeType.FILE && (this.textField.getText() == null || this.textField.getText().isEmpty())) {
            throw new InvalidSettingsException("Please enter a file path.");
        }
        this.updateModel();
    }

    private void updateModel() {
        ((SettingsModelString)this.getModel()).setStringValue(this.textField.getText());
    }

    protected void validateSettingsBeforeSave() throws InvalidSettingsException {
        this.checkAndUpdateModel();
    }

    protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
    }

    protected void setEnabledComponents(boolean enabled) {
        boolean fvmReplacement = this.flowVariableModelButton.getFlowVariableModel().isVariableReplacementEnabled();
        this.textField.setEnabled(enabled && !fvmReplacement);
        this.browseButton.setEnabled(enabled && !fvmReplacement);
        this.flowVariableModelButton.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.textField.setToolTipText(text);
        this.browseButton.setToolTipText(text);
    }

    public void loadSettings(AbstractDropboxConnectorPortObjectSpec spec) {
        this.spec = spec;
    }
}

