/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox;

import com.dropbox.core.v2.DbxPathV2;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.StringCharacterIterator;
import java.util.Locale;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.util.FileUtil;

public final class Utils {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DataCell createStringOrMissing(String value) {
        return value != null ? new StringCell(value) : DataType.getMissingCell();
    }

    public static void validateDropboxPath(String path) throws InvalidSettingsException {
        if (path == null) {
            throw new InvalidSettingsException("path is null");
        }
        String error = DbxPathV2.findError((String)path);
        if (error != null) {
            throw new InvalidSettingsException(error);
        }
    }

    public static void validateDropboxPathNotRoot(String path) throws InvalidSettingsException {
        Utils.validateDropboxPath(path);
        if (path.isEmpty()) {
            throw new InvalidSettingsException("Please select a file/folder path, but not the root");
        }
    }

    public static File getFileFromUrlOrPath(String urlOrPath) {
        if (urlOrPath.startsWith("knime:")) {
            File file;
            try {
                file = FileUtil.getFileFromURL((URL)new URL(urlOrPath));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Invalid URL: " + urlOrPath);
            }
            if (file == null) {
                throw new IllegalArgumentException("Could not resolve URL: " + urlOrPath);
            }
            return file;
        }
        return new File(urlOrPath);
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format(Locale.ENGLISH, "%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String hex(byte[] data) {
        char[] buf = new char[2 * data.length];
        int i = 0;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            buf[i++] = HEX_DIGITS[(b & 0xF0) >>> 4];
            buf[i++] = HEX_DIGITS[b & 0xF];
            ++n2;
        }
        return new String(buf);
    }

    private Utils() {
    }

    public static final class DropboxContentHasher
    extends MessageDigest
    implements Cloneable {
        private MessageDigest overallHasher;
        private MessageDigest blockHasher;
        private int blockPos = 0;
        public static final int BLOCK_SIZE = 0x400000;

        public DropboxContentHasher() {
            this(DropboxContentHasher.newSha256Hasher(), DropboxContentHasher.newSha256Hasher(), 0);
        }

        private DropboxContentHasher(MessageDigest overallHasher, MessageDigest blockHasher, int blockPos) {
            super("Dropbox-Content-Hash");
            this.overallHasher = overallHasher;
            this.blockHasher = blockHasher;
            this.blockPos = blockPos;
        }

        @Override
        protected void engineUpdate(byte input) {
            this.finishBlockIfFull();
            this.blockHasher.update(input);
            ++this.blockPos;
        }

        @Override
        protected int engineGetDigestLength() {
            return this.overallHasher.getDigestLength();
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            int inputEnd = offset + len;
            while (offset < inputEnd) {
                this.finishBlockIfFull();
                int spaceInBlock = 0x400000 - this.blockPos;
                int inputPartEnd = Math.min(inputEnd, offset + spaceInBlock);
                int inputPartLength = inputPartEnd - offset;
                this.blockHasher.update(input, offset, inputPartLength);
                this.blockPos += inputPartLength;
                offset += inputPartLength;
            }
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            int inputEnd = input.limit();
            while (input.position() < inputEnd) {
                this.finishBlockIfFull();
                int spaceInBlock = 0x400000 - this.blockPos;
                int inputPartEnd = Math.min(inputEnd, input.position() + spaceInBlock);
                int inputPartLength = inputPartEnd - input.position();
                input.limit(inputPartEnd);
                this.blockHasher.update(input);
                this.blockPos += inputPartLength;
                input.position(inputPartEnd);
            }
        }

        @Override
        protected byte[] engineDigest() {
            this.finishBlockIfNonEmpty();
            return this.overallHasher.digest();
        }

        @Override
        protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
            this.finishBlockIfNonEmpty();
            return this.overallHasher.digest(buf, offset, len);
        }

        @Override
        protected void engineReset() {
            this.overallHasher.reset();
            this.blockHasher.reset();
            this.blockPos = 0;
        }

        @Override
        public DropboxContentHasher clone() throws CloneNotSupportedException {
            DropboxContentHasher clone = (DropboxContentHasher)super.clone();
            clone.overallHasher = (MessageDigest)clone.overallHasher.clone();
            clone.blockHasher = (MessageDigest)clone.blockHasher.clone();
            return clone;
        }

        private void finishBlock() {
            this.overallHasher.update(this.blockHasher.digest());
            this.blockPos = 0;
        }

        private void finishBlockIfFull() {
            if (this.blockPos == 0x400000) {
                this.finishBlock();
            }
        }

        private void finishBlockIfNonEmpty() {
            if (this.blockPos > 0) {
                this.finishBlock();
            }
        }

        static MessageDigest newSha256Hasher() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AssertionError((Object)"Couldn't create SHA-256 hasher");
            }
        }
    }
}

