/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.copymove2;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.RelocationResult;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.util.ButtonGroupEnumInterface;

class DropboxCopyMove2NodeModel
extends NodeModel {
    private static final MetadataMapper MAPPER = MetadataMapper.DEFAULT;
    static final String CFGKEY_OPERATION = "operation";
    static final String CFGKEY_FROM_PATH = "fromPath";
    static final String CFGKEY_TO_DIRECTORY_PATH = "toDirectoryPath";
    private final SettingsModelString settingsModelOperation = DropboxCopyMove2NodeModel.createSettingsModelOperation();
    private final SettingsModelString settingsModelFromPath = DropboxCopyMove2NodeModel.createSettingsModelFromPath();
    private final SettingsModelString settingsModelToDirectoryPath = DropboxCopyMove2NodeModel.createSettingsModelToDirectoryPath();

    static SettingsModelString createSettingsModelOperation() {
        return new SettingsModelString(CFGKEY_OPERATION, Operation.COPY.toString());
    }

    static SettingsModelString createSettingsModelFromPath() {
        return new SettingsModelString(CFGKEY_FROM_PATH, "");
    }

    static SettingsModelString createSettingsModelToDirectoryPath() {
        return new SettingsModelString(CFGKEY_TO_DIRECTORY_PATH, null);
    }

    protected DropboxCopyMove2NodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        String currentName = this.settingsModelFromPath.getStringValue().replaceAll("^.*\\/", "");
        String fullTargetPath = this.settingsModelToDirectoryPath.getStringValue() + "/" + currentName;
        Operation operation = Operation.getByName(this.settingsModelOperation.getStringValue());
        RelocationResult result = operation.exec(client.files(), this.settingsModelFromPath.getStringValue(), fullTargetPath);
        Metadata metadata = result.getMetadata();
        BufferedDataContainer container = exec.createDataContainer(MAPPER.getSpec());
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), MAPPER.map(metadata)));
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{MAPPER.getSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelOperation.saveSettingsTo(settings);
        this.settingsModelFromPath.saveSettingsTo(settings);
        this.settingsModelToDirectoryPath.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelOperation.validateSettings(settings);
        this.settingsModelFromPath.validateSettings(settings);
        this.settingsModelToDirectoryPath.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelOperation.loadSettingsFrom(settings);
        this.settingsModelFromPath.loadSettingsFrom(settings);
        this.settingsModelToDirectoryPath.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Operation implements ButtonGroupEnumInterface
    {
        COPY("Copy"){

            @Override
            public RelocationResult exec(DbxUserFilesRequests files, String sourcePath, String targetPath) throws DbxException {
                return files.copyV2(sourcePath, targetPath);
            }
        }
        ,
        MOVE("Move"){

            @Override
            public RelocationResult exec(DbxUserFilesRequests files, String sourcePath, String targetPath) throws DbxException {
                return files.moveV2(sourcePath, targetPath);
            }
        };

        private final String label;

        private Operation(String label) {
            this.label = label;
        }

        static Operation getByName(String name) {
            return Arrays.stream(Operation.values()).filter(o -> o.name().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown operation: " + name));
        }

        public abstract RelocationResult exec(DbxUserFilesRequests var1, String var2, String var3) throws DbxException;

        public String getText() {
            return this.label;
        }

        public String getActionCommand() {
            return this.name();
        }

        public String getToolTip() {
            return null;
        }

        public boolean isDefault() {
            return this == COPY;
        }
    }
}

