/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.download;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.download.DropboxDownloadNodeModel;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;

class DropboxDownloadNodeDialog
extends DefaultNodeSettingsPane {
    private static final String HISTORY_ID = "com.nodepit.knime.dropbox.download.destinationDirectory";
    private final SettingsModelString settingsModelPath = DropboxDownloadNodeModel.createSettingsModelPath();
    private final DialogComponentDbxPath pathChooser;

    DropboxDownloadNodeDialog() {
        FlowVariableModel fvModelPath = this.createFlowVariableModel("path", FlowVariable.Type.STRING);
        this.pathChooser = new DialogComponentDbxPath(this.settingsModelPath, "Remote File Path", DropboxPicker.NodeType.FILE, fvModelPath);
        this.addDialogComponent(this.pathChooser);
        FlowVariableModel fvModelDestDir = this.createFlowVariableModel("destinationDirectory", FlowVariable.Type.STRING);
        DialogComponentFileChooser fileChooser = new DialogComponentFileChooser(DropboxDownloadNodeModel.createSettingsModelTargetDirectory(), HISTORY_ID, 0, true, fvModelDestDir, new String[0]);
        fileChooser.setBorderTitle("Local Target Folder");
        this.addDialogComponent((DialogComponent)fileChooser);
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPath(this.settingsModelPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.pathChooser.loadSettings(spec);
    }
}

