/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.upload;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import com.nodepit.knime.dropbox.upload.DropboxUploadNodeModel;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;

class DropboxUploadNodeDialog
extends DefaultNodeSettingsPane {
    private static final String HISTORY_ID = "com.nodepit.knime.dropbox.upload.localFile";
    private final SettingsModelString settingsModelRemoteDirectoryPath = DropboxUploadNodeModel.createSettingsModelRemoteDirectoryPath();
    private final DialogComponentDbxPath targetPathChooser;

    DropboxUploadNodeDialog() {
        this.setDefaultTabTitle("General");
        FlowVariableModel fvModelLocalFile = this.createFlowVariableModel("localFile", FlowVariable.Type.STRING);
        DialogComponentFileChooser fileChooser = new DialogComponentFileChooser(DropboxUploadNodeModel.createSettingsModelLocalFile(), HISTORY_ID, 0, false, fvModelLocalFile, new String[0]);
        fileChooser.setBorderTitle("Local Source File");
        this.addDialogComponent((DialogComponent)fileChooser);
        FlowVariableModel fvModelPath = this.createFlowVariableModel("path", FlowVariable.Type.STRING);
        this.targetPathChooser = new DialogComponentDbxPath(this.settingsModelRemoteDirectoryPath, "Remote Target Folder", DropboxPicker.NodeType.FOLDER, fvModelPath);
        this.addDialogComponent(this.targetPathChooser);
        this.createNewTab("Advanced");
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)DropboxUploadNodeModel.createSettingsModelChunkSize(), "Chunk Size (kB)", (Number)512));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(DropboxUploadNodeModel.createSettingsModelAllProperties(), "Return All Properties"));
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPath(this.settingsModelRemoteDirectoryPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.targetPathChooser.loadSettings(spec);
    }
}

