/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox;

import com.dropbox.core.v2.files.DeletedMetadata;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.MediaInfo;
import com.dropbox.core.v2.files.MediaMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.nodepit.knime.dropbox.Utils;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.zoneddatetime.ZonedDateTimeCellFactory;

public class MetadataMapper {
    public static final MetadataMapper DEFAULT = new MetadataMapper(false);
    public static final MetadataMapper ALL = new MetadataMapper(true);
    private final boolean all;

    private MetadataMapper(boolean all) {
        this.all = all;
    }

    public DataTableSpec getSpec() {
        DataTableSpecCreator sc = new DataTableSpecCreator();
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Type", StringCell.TYPE).createSpec()});
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Name", StringCell.TYPE).createSpec()});
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Path", StringCell.TYPE).createSpec()});
        if (this.all) {
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Path (display)", StringCell.TYPE).createSpec()});
        }
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Modified (client)", ZonedDateTimeCellFactory.TYPE).createSpec()});
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Modified (server)", ZonedDateTimeCellFactory.TYPE).createSpec()});
        sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Size", LongCell.TYPE).createSpec()});
        if (this.all) {
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("ID", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Revision ID", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Content Hash", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Lock: Created", ZonedDateTimeCellFactory.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Lock: Is Lockholder", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Lock: Lockholder Account ID", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Lock: Lockholder Name", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Has Explicit Shared Members", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Is Downloadable", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Export As", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Meta: Height", LongCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Meta: Width", LongCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Meta: Latitude", DoubleCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Meta: Longitude", DoubleCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Meta: Time Taken", ZonedDateTimeCellFactory.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: Read Only", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: Modified By", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: Parent Shared Folder ID", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: No Access", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: Shared Folder ID", StringCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Sharing: Traverse Only", BooleanCell.TYPE).createSpec()});
            sc.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Symlink: Target", StringCell.TYPE).createSpec()});
        }
        return sc.createSpec();
    }

    public List<DataCell> map(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata was null");
        ArrayList<DataCell> cells = new ArrayList<DataCell>();
        cells.add(Utils.createStringOrMissing(MetadataMapper.getType(metadata)));
        cells.add(Utils.createStringOrMissing(metadata.getName()));
        cells.add(Utils.createStringOrMissing(metadata.getPathLower()));
        if (this.all) {
            cells.add(Utils.createStringOrMissing(metadata.getPathDisplay()));
        }
        DataCell clientModified = DataType.getMissingCell();
        DataCell serverModified = DataType.getMissingCell();
        DataCell size = DataType.getMissingCell();
        DataCell id = DataType.getMissingCell();
        DataCell rev = DataType.getMissingCell();
        DataCell contentHash = DataType.getMissingCell();
        DataCell lockCreated = DataType.getMissingCell();
        DataCell isLockholder = DataType.getMissingCell();
        DataCell lockholderAccountId = DataType.getMissingCell();
        DataCell lockerholderName = DataType.getMissingCell();
        DataCell hasExplicitSharedMembers = DataType.getMissingCell();
        DataCell isDownloadable = DataType.getMissingCell();
        DataCell exportAs = DataType.getMissingCell();
        DataCell metaHeight = DataType.getMissingCell();
        DataCell metaWidth = DataType.getMissingCell();
        DataCell metaLatitude = DataType.getMissingCell();
        DataCell metaLongitude = DataType.getMissingCell();
        DataCell metaTimeTaken = DataType.getMissingCell();
        DataCell sharingReadOnly = DataType.getMissingCell();
        DataCell sharingModifiedBy = DataType.getMissingCell();
        DataCell sharingParentSharedFolderId = DataType.getMissingCell();
        DataCell sharingNoAccess = DataType.getMissingCell();
        DataCell sharingSharedFolderId = DataType.getMissingCell();
        DataCell sharingTraverseOnly = DataType.getMissingCell();
        DataCell symlinkTarget = DataType.getMissingCell();
        if (!(metadata instanceof DeletedMetadata)) {
            if (metadata instanceof FileMetadata) {
                MediaMetadata metadataValue;
                MediaInfo mediaInfo;
                FileMetadata fileMetadata = (FileMetadata)metadata;
                clientModified = MetadataMapper.createZonedDateTime(fileMetadata.getClientModified());
                serverModified = MetadataMapper.createZonedDateTime(fileMetadata.getServerModified());
                size = new LongCell(fileMetadata.getSize());
                id = Utils.createStringOrMissing(fileMetadata.getId());
                rev = Utils.createStringOrMissing(fileMetadata.getRev());
                contentHash = Utils.createStringOrMissing(fileMetadata.getContentHash());
                if (fileMetadata.getFileLockInfo() != null) {
                    lockCreated = MetadataMapper.createZonedDateTime(fileMetadata.getFileLockInfo().getCreated());
                    isLockholder = BooleanCell.BooleanCellFactory.create((boolean)fileMetadata.getFileLockInfo().getIsLockholder());
                    lockholderAccountId = Utils.createStringOrMissing(fileMetadata.getFileLockInfo().getLockholderAccountId());
                    lockerholderName = Utils.createStringOrMissing(fileMetadata.getFileLockInfo().getLockholderName());
                }
                if (fileMetadata.getHasExplicitSharedMembers() != null) {
                    hasExplicitSharedMembers = BooleanCell.BooleanCellFactory.create((boolean)fileMetadata.getHasExplicitSharedMembers());
                }
                isDownloadable = BooleanCell.BooleanCellFactory.create((boolean)fileMetadata.getIsDownloadable());
                if (fileMetadata.getExportInfo() != null) {
                    exportAs = Utils.createStringOrMissing(fileMetadata.getExportInfo().getExportAs());
                }
                if ((mediaInfo = fileMetadata.getMediaInfo()) != null && (metadataValue = mediaInfo.getMetadataValue()) != null) {
                    if (metadataValue.getDimensions() != null) {
                        metaHeight = new LongCell(metadataValue.getDimensions().getHeight());
                        metaWidth = new LongCell(metadataValue.getDimensions().getWidth());
                    }
                    if (metadataValue.getLocation() != null) {
                        metaLatitude = new DoubleCell(metadataValue.getLocation().getLatitude());
                        metaLongitude = new DoubleCell(metadataValue.getLocation().getLongitude());
                    }
                    metaTimeTaken = MetadataMapper.createZonedDateTime(metadataValue.getTimeTaken());
                }
                if (fileMetadata.getSharingInfo() != null) {
                    sharingReadOnly = BooleanCell.BooleanCellFactory.create((boolean)fileMetadata.getSharingInfo().getReadOnly());
                    sharingModifiedBy = Utils.createStringOrMissing(fileMetadata.getSharingInfo().getModifiedBy());
                    sharingParentSharedFolderId = Utils.createStringOrMissing(fileMetadata.getSharingInfo().getParentSharedFolderId());
                }
                if (fileMetadata.getSymlinkInfo() != null) {
                    symlinkTarget = Utils.createStringOrMissing(fileMetadata.getSymlinkInfo().getTarget());
                }
            } else if (metadata instanceof FolderMetadata) {
                FolderMetadata folderMetadata = (FolderMetadata)metadata;
                id = Utils.createStringOrMissing(folderMetadata.getId());
                if (folderMetadata.getSharingInfo() != null) {
                    sharingReadOnly = BooleanCell.BooleanCellFactory.create((boolean)folderMetadata.getSharingInfo().getReadOnly());
                    sharingParentSharedFolderId = Utils.createStringOrMissing(folderMetadata.getSharingInfo().getParentSharedFolderId());
                    sharingNoAccess = BooleanCell.BooleanCellFactory.create((boolean)folderMetadata.getSharingInfo().getNoAccess());
                    sharingSharedFolderId = Utils.createStringOrMissing(folderMetadata.getSharingInfo().getSharedFolderId());
                    sharingTraverseOnly = BooleanCell.BooleanCellFactory.create((boolean)folderMetadata.getSharingInfo().getTraverseOnly());
                }
            }
        }
        cells.add(clientModified);
        cells.add(serverModified);
        cells.add(size);
        if (this.all) {
            cells.add(id);
            cells.add(rev);
            cells.add(contentHash);
            cells.add(lockCreated);
            cells.add(isLockholder);
            cells.add(lockholderAccountId);
            cells.add(lockerholderName);
            cells.add(hasExplicitSharedMembers);
            cells.add(isDownloadable);
            cells.add(exportAs);
            cells.add(metaHeight);
            cells.add(metaWidth);
            cells.add(metaLatitude);
            cells.add(metaLongitude);
            cells.add(metaTimeTaken);
            cells.add(sharingReadOnly);
            cells.add(sharingModifiedBy);
            cells.add(sharingParentSharedFolderId);
            cells.add(sharingNoAccess);
            cells.add(sharingSharedFolderId);
            cells.add(sharingTraverseOnly);
            cells.add(symlinkTarget);
        }
        return cells;
    }

    private static DataCell createZonedDateTime(Date date) {
        if (date == null) {
            return DataType.getMissingCell();
        }
        return ZonedDateTimeCellFactory.create((ZonedDateTime)ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    private static String getType(Metadata metadata) {
        if (metadata instanceof DeletedMetadata) {
            return "Deleted";
        }
        if (metadata instanceof FileMetadata) {
            return "File";
        }
        if (metadata instanceof FolderMetadata) {
            return "Folder";
        }
        return null;
    }
}

