/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.connect.oauth;

import com.github.scribejava.apis.DropboxApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.nodepit.knime.dropbox.connect.DropboxConnectorNodeModel;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

@Deprecated
class DropboxOAuthConnectorNodeDialog
extends DefaultNodeSettingsPane {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DropboxOAuthConnectorNodeDialog.class);
    private static final String KEY = "ahviff37pooa3cn";
    private static final String SECRET = "4yio7bp0i7c2fnk";
    private static final int PORT = 55931;
    private static final String REDIRECT_URI = "http://localhost:55931";
    private static final OAuth20Service OAUTH_SERVICE = new ServiceBuilder("ahviff37pooa3cn").apiSecret("4yio7bp0i7c2fnk").callback("http://localhost:55931").build((DefaultApi20)DropboxApi.instance());
    private static Server server;
    private final SettingsModelString accessToken = DropboxConnectorNodeModel.createSettingsModelAccessToken();
    private final DialogComponentLabel accessTokenLabel = new DialogComponentLabel("");

    DropboxOAuthConnectorNodeDialog() {
        this.addDialogComponent((DialogComponent)this.accessTokenLabel);
        DialogComponentButton accessTokenButton = new DialogComponentButton("Authorize Access");
        this.addDialogComponent((DialogComponent)accessTokenButton);
        accessTokenButton.addActionListener(e -> new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    DropboxOAuthConnectorNodeDialog.this.startServerIfNotYetRunning();
                }
                catch (Exception e) {
                    DropboxOAuthConnectorNodeDialog.this.updateStatus("Could not start HTTP server on port 55931: " + e.getMessage(), e);
                    return null;
                }
                Desktop.getDesktop().browse(new URI(OAUTH_SERVICE.getAuthorizationUrl()));
                DropboxOAuthConnectorNodeDialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                return null;
            }
        }.execute());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        try {
            this.accessToken.loadSettingsFrom(settings);
            if (this.accessToken.getStringValue() != null) {
                this.accessTokenLabel.setText("Access token: " + this.accessToken.getStringValue());
            } else {
                this.accessTokenLabel.setText("Click the button to request an access token.");
            }
        }
        catch (InvalidSettingsException e) {
            LOGGER.debug((Object)"Encountered ISE", (Throwable)e);
        }
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.accessToken.saveSettingsTo(settings);
    }

    public void onClose() {
        this.stopServerIfRunning();
    }

    private void startServerIfNotYetRunning() throws Exception {
        if (server != null && server.isRunning()) {
            LOGGER.debug((Object)"Server is already running");
            return;
        }
        server = new Server(55931);
        server.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                LOGGER.debugWithFormat(request.toString(), new Object[0]);
                if (request.getHttpURI().getPath().equals("/") && request.getHttpURI().getQuery().startsWith("code=")) {
                    String code = request.getHttpURI().getQuery().replaceAll("^code=", "");
                    DropboxOAuthConnectorNodeDialog.this.receivedCode(code);
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)DropboxOAuthConnectorNodeDialog.getAccessGrantedHtml(), (Callback)callback);
                } else if (!request.getHttpURI().getPath().equals("/") || !request.getHttpURI().getQuery().contains("error=")) {
                    response.setStatus(404);
                }
                return true;
            }
        });
        this.updateStatus("Starting HTTP server on 55931", null);
        server.start();
    }

    private void stopServerIfRunning() {
        if (server != null && server.isRunning()) {
            try {
                this.updateStatus("Stopping running server", null);
                server.stop();
                server = null;
            }
            catch (Exception e) {
                this.updateStatus("Error: Could not stop running server", e);
            }
        }
    }

    private void updateStatus(String message, Exception ex) {
        this.accessTokenLabel.setText(message);
        if (ex != null) {
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            LOGGER.info((Object)message);
        }
    }

    private void receivedCode(String code) {
        this.updateStatus("Authorization code: " + code, null);
        try {
            OAuth2AccessToken accessTokenResult = OAUTH_SERVICE.getAccessToken(code);
            String accessToken = accessTokenResult.getAccessToken();
            this.updateStatus("Access token: " + accessToken, null);
            this.accessToken.setStringValue(accessToken);
        }
        catch (Exception e) {
            this.updateStatus("Could not get access token: " + e.getMessage(), e);
        }
    }

    private static String getAccessGrantedHtml() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DropboxOAuthConnectorNodeDialog.class.getResourceAsStream("AccessGranted.html"), StandardCharsets.UTF_8));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

