/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.copymove;

import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.RelocationResult;
import com.nodepit.knime.dropbox.MetadataMapper;
import com.nodepit.knime.dropbox.port.DropboxConnectorPortObject;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

@Deprecated
class DropboxCopyMoveNodeModel
extends NodeModel {
    private static final MetadataMapper MAPPER = MetadataMapper.DEFAULT;
    static final String[] OPERATIONS = new String[]{"Copy", "Move"};
    static final String CFGKEY_OPERATION = "operation";
    static final String CFGKEY_FROM_PATH = "fromPath";
    static final String CFGKEY_TO_PATH = "toPath";
    private final SettingsModelString settingsModelOperation = DropboxCopyMoveNodeModel.createSettingsModelOperation();
    private final SettingsModelString settingsModelFromPath = DropboxCopyMoveNodeModel.createSettingsModelFromPath();
    private final SettingsModelString settingsModelToPath = DropboxCopyMoveNodeModel.createSettingsModelToPath();

    static SettingsModelString createSettingsModelOperation() {
        return new SettingsModelString(CFGKEY_OPERATION, OPERATIONS[0]);
    }

    static SettingsModelString createSettingsModelFromPath() {
        return new SettingsModelString(CFGKEY_FROM_PATH, "");
    }

    static SettingsModelString createSettingsModelToPath() {
        return new SettingsModelString(CFGKEY_TO_PATH, null);
    }

    protected DropboxCopyMoveNodeModel() {
        super(new PortType[]{DropboxConnectorPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, DropboxConnectorPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        DropboxConnectorPortObject connector = (DropboxConnectorPortObject)inObjects[0];
        DbxClientV2 client = connector.getSpec().getClient();
        RelocationResult result = null;
        switch (this.settingsModelOperation.getStringValue()) {
            case "Copy": {
                result = client.files().copyV2(this.settingsModelFromPath.getStringValue(), this.settingsModelToPath.getStringValue());
                break;
            }
            case "Move": {
                result = client.files().moveV2(this.settingsModelFromPath.getStringValue(), this.settingsModelToPath.getStringValue());
                break;
            }
            default: {
                throw new InvalidSettingsException("operation is not valid");
            }
        }
        Metadata metadata = result.getMetadata();
        BufferedDataContainer container = exec.createDataContainer(MAPPER.getSpec());
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), MAPPER.map(metadata)));
        container.close();
        BufferedDataTable outTable = container.getTable();
        return new PortObject[]{outTable, connector};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{MAPPER.getSpec(), inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsModelOperation.saveSettingsTo(settings);
        this.settingsModelFromPath.saveSettingsTo(settings);
        this.settingsModelToPath.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelOperation.validateSettings(settings);
        this.settingsModelFromPath.validateSettings(settings);
        this.settingsModelToPath.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsModelOperation.loadSettingsFrom(settings);
        this.settingsModelFromPath.loadSettingsFrom(settings);
        this.settingsModelToPath.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

