/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.copymove2;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.copymove2.DropboxCopyMove2NodeModel;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButtonGroup;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.ButtonGroupEnumInterface;
import org.knime.core.node.workflow.FlowVariable;

class DropboxCopyMove2NodeDialog
extends DefaultNodeSettingsPane {
    private final SettingsModelString settingsModelOperation = DropboxCopyMove2NodeModel.createSettingsModelOperation();
    private final SettingsModelString settingsModelFromPath = DropboxCopyMove2NodeModel.createSettingsModelFromPath();
    private final SettingsModelString settingsModelToDirectoryPath = DropboxCopyMove2NodeModel.createSettingsModelToDirectoryPath();
    private final DialogComponentDbxPath fromPathChooser;
    private final DialogComponentDbxPath toDirectoryPathChooser;

    DropboxCopyMove2NodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentButtonGroup(this.settingsModelOperation, "Operation", false, (ButtonGroupEnumInterface[])DropboxCopyMove2NodeModel.Operation.values()));
        FlowVariableModel fvFromModel = this.createFlowVariableModel("fromPath", FlowVariable.Type.STRING);
        this.fromPathChooser = new DialogComponentDbxPath(this.settingsModelFromPath, "Source File/Folder Path", DropboxPicker.NodeType.FILE_OR_FOLDER, fvFromModel);
        this.addDialogComponent(this.fromPathChooser);
        FlowVariableModel fvToDirectoryModel = this.createFlowVariableModel("toDirectoryPath", FlowVariable.Type.STRING);
        this.toDirectoryPathChooser = new DialogComponentDbxPath(this.settingsModelToDirectoryPath, "Target Folder Path", DropboxPicker.NodeType.FOLDER, fvToDirectoryModel);
        this.addDialogComponent(this.toDirectoryPathChooser);
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPath(this.settingsModelFromPath.getStringValue());
        Utils.validateDropboxPath(this.settingsModelToDirectoryPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.fromPathChooser.loadSettings(spec);
        this.toDirectoryPathChooser.loadSettings(spec);
    }
}

