/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.delete;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.delete.DropboxDeleteNodeModel;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;

class DropboxDeleteNodeDialog
extends DefaultNodeSettingsPane {
    private final SettingsModelString settingsModelPath = DropboxDeleteNodeModel.createSettingsModelPath();
    private final DialogComponentDbxPath pathChooser;

    DropboxDeleteNodeDialog() {
        FlowVariableModel fvModel = this.createFlowVariableModel("path", FlowVariable.Type.STRING);
        this.pathChooser = new DialogComponentDbxPath(this.settingsModelPath, "Remote Path", DropboxPicker.NodeType.FILE_OR_FOLDER, fvModel);
        this.addDialogComponent(this.pathChooser);
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPath(this.settingsModelPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.pathChooser.loadSettings(spec);
    }
}

